/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import java.lang.reflect.Field;
import wanion.unidict.integration.AbstractIntegrationThread;

final class ActuallyAdditionsIntegration
extends AbstractIntegrationThread {
    private Field crusherOutputOne;
    private Field crusherOutputTwo;
    private Field empowererOutput;
    private Field reconstructorOutput;

    public ActuallyAdditionsIntegration() {
        super("Actually Additions");
        try {
            this.crusherOutputOne = CrusherRecipe.class.getDeclaredField("outputOne");
            this.crusherOutputOne.setAccessible(true);
            this.crusherOutputTwo = CrusherRecipe.class.getDeclaredField("outputTwo");
            this.crusherOutputTwo.setAccessible(true);
            this.empowererOutput = EmpowererRecipe.class.getDeclaredField("output");
            this.empowererOutput.setAccessible(true);
            this.reconstructorOutput = LensConversionRecipe.class.getDeclaredField("output");
            this.reconstructorOutput.setAccessible(true);
        }
        catch (NoSuchFieldException | NullPointerException e) {
            this.logger.error("Could not find Actually Additions fields!");
            e.printStackTrace();
        }
    }

    public String call() {
        try {
            this.fixCrusherRecipes();
            this.fixEmpowererRecipes();
            this.fixAtomicReconstructorRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Actually unified the Additions!";
    }

    private void fixCrusherRecipes() {
        ActuallyAdditionsAPI.CRUSHER_RECIPES.forEach(recipe -> {
            if (this.crusherOutputOne != null && recipe.getOutputOne() != null) {
                try {
                    this.crusherOutputOne.set(recipe, this.resourceHandler.getMainItemStack(recipe.getOutputOne()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (this.crusherOutputTwo != null && recipe.getOutputTwo() != null) {
                try {
                    this.crusherOutputTwo.set(recipe, this.resourceHandler.getMainItemStack(recipe.getOutputTwo()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fixEmpowererRecipes() {
        if (this.empowererOutput == null) {
            return;
        }
        ActuallyAdditionsAPI.EMPOWERER_RECIPES.forEach(recipe -> {
            if (recipe.getOutput() != null) {
                try {
                    this.empowererOutput.set(recipe, this.resourceHandler.getMainItemStack(recipe.getOutput()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fixAtomicReconstructorRecipes() {
        if (this.reconstructorOutput == null) {
            return;
        }
        ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES.forEach(recipe -> {
            if (recipe.getOutput() != null) {
                try {
                    this.reconstructorOutput.set(recipe, this.resourceHandler.getMainItemStack(recipe.getOutput()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

