/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.helper;

import com.animania.Animania;
import com.animania.common.helper.StringParser;
import com.animania.config.AnimaniaConfig;
import com.animania.network.client.TileEntitySyncPacket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class AnimaniaHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static ItemStack getItem(String name) {
        Item item;
        ItemStack stack = ItemStack.field_190927_a;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        metaLoc = name.indexOf("#");
        if (metaLoc > -1) {
            metaVal = name.substring(metaLoc);
            name = name.replace(metaVal, "");
            metaVal = metaVal.replace("#", "");
            metaFlag = true;
        }
        if ((item = Item.func_111206_d((String)name)) != null) {
            stack = metaFlag ? new ItemStack(item, 1, Integer.parseInt(metaVal)) : new ItemStack(item, 1);
        }
        return stack;
    }

    public static Block getBlock(String name) {
        Block b;
        if (name.contains("#")) {
            name = name.substring(0, name.indexOf("#"));
        }
        if ((b = Block.func_149684_b((String)name)) == null) {
            return Blocks.field_150350_a;
        }
        return b;
    }

    public static IBlockState getBlockState(String name) {
        Block b;
        int meta = 0;
        if (name.contains("#")) {
            try {
                meta = Integer.parseInt(name.substring(name.indexOf("#")).replace("#", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = name.substring(0, name.indexOf("#"));
        }
        if ((b = Block.func_149684_b((String)name)) == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return b.func_176203_a(meta);
    }

    public static void sendTileEntityUpdate(TileEntity tile) {
        if (tile != null && tile.func_145831_w() != null && !tile.func_145831_w().field_72995_K) {
            NBTTagCompound compound = new NBTTagCompound();
            compound = tile.func_189515_b(compound);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("data", (NBTBase)compound);
            data.func_74768_a("x", tile.func_174877_v().func_177958_n());
            data.func_74768_a("y", tile.func_174877_v().func_177956_o());
            data.func_74768_a("z", tile.func_174877_v().func_177952_p());
            Animania.network.sendToAllAround((IMessage)new TileEntitySyncPacket(data), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), 64.0));
        }
    }

    public static ItemStack getItemStack(JsonObject json) {
        String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.func_77614_k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack(item, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
    }

    public static void addItem(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static <T extends EntityLivingBase> List<T> getEntitiesInRange(Class<? extends T> filterEntity, double range, World world, Entity theEntity) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB(theEntity.field_70165_t - range, theEntity.field_70163_u - range, theEntity.field_70161_v - range, theEntity.field_70165_t + range, theEntity.field_70163_u + range, theEntity.field_70161_v + range));
        list.removeIf(e -> e == theEntity);
        return list;
    }

    public static <T extends EntityLivingBase> List<T> getEntitiesInRangeWithPredicate(Class<? extends T> filterEntity, double range, World world, Entity theEntity, Predicate<T> predicate) {
        List<T> list = AnimaniaHelper.getEntitiesInRange(filterEntity, range, world, theEntity);
        list.removeIf(predicate.negate());
        return list;
    }

    public static <T extends EntityLivingBase> List<T> getEntitiesInRange(Class<? extends T> filterEntity, double range, World world, BlockPos pos) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB((double)pos.func_177958_n() - range, (double)pos.func_177956_o() - range, (double)pos.func_177952_p() - range, (double)pos.func_177958_n() + range, (double)pos.func_177956_o() + range, (double)pos.func_177952_p() + range));
        return list;
    }

    public static <T extends Entity> List<T> getEntitiesInRangeGeneric(Class<? extends T> filterEntity, double range, World world, Entity theEntity) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB(theEntity.field_70165_t - range, theEntity.field_70163_u - range, theEntity.field_70161_v - range, theEntity.field_70165_t + range, theEntity.field_70163_u + range, theEntity.field_70161_v + range));
        return list;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static boolean hasFluid(ItemStack stack, Fluid fluid) {
        return FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).amount >= 1000 && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == fluid;
    }

    public static boolean isEmptyFluidContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack) == null;
    }

    public static boolean isWaterContainer(ItemStack stack) {
        return AnimaniaHelper.hasFluid(stack, FluidRegistry.WATER);
    }

    public static ItemStack emptyContainer(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)copy, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151133_ar)), (int)1000, null, (boolean)true);
        return result.result;
    }

    public static boolean containsItemStack(Collection<ItemStack> stacks, ItemStack toSearch) {
        for (ItemStack s : stacks) {
            if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)toSearch)) continue;
            return true;
        }
        return false;
    }

    public static Item[] getItemArray(String[] names) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (String name : names) {
            Item i = StringParser.getItem(name);
            if (i != null) {
                list.add(i);
                continue;
            }
            NonNullList stacks = OreDictionary.getOres((String)name);
            if (stacks.isEmpty()) continue;
            for (ItemStack s : stacks) {
                list.add(s.func_77973_b());
            }
        }
        return list.toArray(new Item[list.size()]);
    }

    public static ItemStack[] getItemStackArray(String[] names) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String name : names) {
            ItemStack i = StringParser.getItemStack(name);
            if (!i.func_190926_b()) {
                list.add(i);
                continue;
            }
            NonNullList stacks = OreDictionary.getOres((String)name);
            if (stacks.isEmpty()) continue;
            for (ItemStack s : stacks) {
                list.add(s);
            }
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    public static BiomeDictionary.Type[] getBiomeTypes(String[] types) {
        BiomeDictionary.Type[] bt = new BiomeDictionary.Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            String s = types[i].toUpperCase();
            bt[i] = BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        }
        return bt;
    }

    public static String translateWithFormattingCodes(String s) {
        String[] split = s.split(" ");
        String result = s;
        for (String ss : split) {
            String stripped = TextFormatting.func_110646_a((String)ss);
            String translated = I18n.func_74838_a((String)stripped);
            result = result.replace(stripped, translated);
        }
        return result;
    }

    public static Object getConfigValue(String configName) {
        List<Configuration> configs = AnimaniaConfig.EventHandler.getConfiguration();
        for (Configuration config : configs) {
            Property prop;
            String[] split;
            if (config == null) continue;
            String[] firstSplit = configName.split(",");
            String[] output = new String[firstSplit.length];
            boolean doReturn = false;
            if (firstSplit.length > 1) {
                for (int i = 0; i < firstSplit.length; ++i) {
                    Property prop2;
                    String conf = firstSplit[i];
                    String[] split2 = conf.split(";");
                    if (split2.length <= 1 || !config.hasCategory(split2[0]) || !config.getCategory(split2[0]).containsKey(split2[1]) || (prop2 = config.getCategory(split2[0]).get(split2[1])) == null) continue;
                    output[i] = prop2.getString();
                    doReturn = true;
                }
                if (doReturn) {
                    return output;
                }
            }
            if ((split = configName.split(";")).length <= 1 || !config.hasCategory(split[0]) || !config.getCategory(split[0]).containsKey(split[1]) || (prop = config.getCategory(split[0]).get(split[1])) == null) continue;
            if (prop.isBooleanList()) {
                return prop.getBooleanList();
            }
            if (prop.isBooleanValue()) {
                return prop.getBoolean();
            }
            if (prop.isDoubleList()) {
                return prop.getDoubleList();
            }
            if (prop.isDoubleValue()) {
                return prop.getDouble();
            }
            if (prop.isIntList()) {
                return prop.getIntList();
            }
            if (prop.isIntValue()) {
                return prop.getInt();
            }
            if (prop.isList()) {
                return prop.getStringList();
            }
            if (prop.isLongValue()) {
                return prop.getLong();
            }
            if (prop.getString() == null) continue;
            return prop.getString();
        }
        return "";
    }

    public static List<IRecipe> getRecipesForOutput(String output) {
        String[] split;
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (String s : split = output.split(",")) {
            ItemStack stack = StringParser.getItemStack(s);
            if (stack.func_190926_b()) {
                IRecipe re = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(s));
                if (re == null) continue;
                recipes.add(re);
                continue;
            }
            stack.func_190920_e(1);
            for (IRecipe r : ForgeRegistries.RECIPES) {
                ItemStack outputStack = r.func_77571_b().func_77946_l();
                outputStack.func_190920_e(1);
                if (!ItemStack.func_77989_b((ItemStack)outputStack, (ItemStack)stack)) continue;
                recipes.add(r);
            }
        }
        return recipes;
    }

    public static ItemStack[] getItemsForLoottable(ResourceLocation table) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        table = new ResourceLocation(table.func_110624_b(), "loot_tables/" + table.func_110623_a() + ".json");
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(table).func_110527_b();
            JsonParser parser = new JsonParser();
            JsonObject base = (JsonObject)parser.parse((Reader)new InputStreamReader(stream));
            JsonArray pools = base.getAsJsonArray("pools");
            for (int i = 0; i < pools.size(); ++i) {
                JsonArray entries = pools.get(i).getAsJsonObject().getAsJsonArray("entries");
                for (int k = 0; k < entries.size(); ++k) {
                    String name = entries.get(k).getAsJsonObject().get("name").getAsString();
                    Item item = Item.func_111206_d((String)name);
                    if (item == null) continue;
                    ItemStack stack = new ItemStack(item);
                    if (item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                        stack = AnimaniaHelper.addTooltipToStack(stack, I18n.func_74838_a((String)"manual.blocks.wool.colored"));
                    }
                    stacks.add(stack);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }

    public static ItemStack addTooltipToStack(ItemStack stack, String tooltip) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + tooltip));
        display.func_74782_a("Lore", (NBTBase)lore);
        tag.func_74782_a("display", (NBTBase)display);
        stack.func_77982_d(tag);
        return stack;
    }

    public static ResourceLocation[] getResourceLocations(String ... strings) {
        ResourceLocation[] res = new ResourceLocation[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            res[i] = new ResourceLocation(strings[i]);
        }
        return res;
    }

    public static boolean hasBiomeType(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type t : types) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)) continue;
            return true;
        }
        return false;
    }

    public static boolean spawnEntity(World world, Entity entity) {
        if (!world.field_72995_K) {
            WorldServer ws = (WorldServer)world;
            while (ws.func_175733_a(entity.func_110124_au()) != null) {
                entity.func_184221_a(MathHelper.func_180182_a((Random)Animania.RANDOM));
            }
        }
        return world.func_72838_d(entity);
    }
}

