/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons;

import com.animania.Animania;
import com.animania.api.addons.AnimaniaAddon;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class AddonResourcePack {
    public static File getAddonFile(AnimaniaAddon addon) {
        try {
            String classpath = addon.getClass().getResource(addon.getClass().getSimpleName() + ".class").getFile();
            classpath = classpath.substring(0, classpath.indexOf("!"));
            classpath = classpath.substring(classpath.indexOf(":") + 1, classpath.length());
            classpath = classpath.replace("/./", "/");
            String path = classpath = URLDecoder.decode(classpath);
            File f = new File(path);
            return f;
        }
        catch (Exception e) {
            System.out.println("Failed to get addon file!");
            Animania.LOGGER.error((Object)e);
            return null;
        }
    }

    public static Tuple<FileSystem, Path> getAddonPath(AnimaniaAddon addon) {
        try {
            Path myPath;
            URI classpath = addon.getClass().getResource("/assets/" + addon.getAddonID() + "/").toURI();
            System.out.println("Path classpath: " + classpath);
            FileSystem fs = null;
            if (classpath.getScheme().equals("jar")) {
                fs = FileSystems.newFileSystem(classpath, Collections.emptyMap());
                myPath = fs.getPath(".", new String[0]);
            } else {
                myPath = Paths.get(classpath);
            }
            return new Tuple((Object)fs, (Object)myPath);
        }
        catch (Exception e) {
            System.out.println("Failed to get addon path!");
            Animania.LOGGER.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static class Folder
    extends FolderResourcePack {
        private AnimaniaAddon addon;
        public List<ResourceLocation> manualFiles = new ArrayList<ResourceLocation>();

        public Folder(AnimaniaAddon addon) {
            super(Folder.getAddonFile(addon));
            this.addon = addon;
        }

        public String func_130077_b() {
            return "AnimaniaAddonResourcePack:" + this.addon.getAddonID();
        }

        private static File getAddonFile(AnimaniaAddon addon) {
            File animania = Loader.instance().activeModContainer().getSource();
            return animania;
        }

        protected InputStream func_110591_a(String resourceName) throws IOException {
            if (resourceName.equals("pack.mcmeta")) {
                return Animania.class.getResourceAsStream("/addons.mcmeta");
            }
            resourceName = resourceName.replace("assets/", "assets/" + this.addon.getAddonID() + "/");
            return super.func_110591_a(resourceName);
        }

        protected boolean func_110593_b(String name) {
            return this.getFile(name.replace("assets/", "assets/" + this.addon.getAddonID() + "/")) != null;
        }

        @Nullable
        private File getFile(String name) {
            try {
                File file1 = new File(this.field_110597_b, name);
                if (file1.isFile() && Folder.func_191384_a((File)file1, (String)name)) {
                    return file1;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public Set<String> func_110587_b() {
            HashSet set = Sets.newHashSet();
            File file1 = new File(this.field_110597_b, "assets/" + this.addon.getAddonID() + "/");
            this.manualFiles.clear();
            if (file1.isDirectory()) {
                try {
                    Iterator it = Files.walk(file1.toPath(), new FileVisitOption[0]).iterator();
                    while (it.hasNext()) {
                        String s = ((Path)it.next()).toString();
                        if (!s.contains("manual") || !s.endsWith(".json")) continue;
                        String resLoc = s.substring(s.indexOf("manual"), s.length());
                        ResourceLocation loc = new ResourceLocation("animania", resLoc.replace("\\", "/"));
                        this.manualFiles.add(loc);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (File file2 : file1.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                    String s = Folder.func_110595_a((File)file1, (File)file2);
                    if (s.equals(s.toLowerCase(Locale.ROOT))) {
                        set.add(s.substring(0, s.length() - 1));
                        continue;
                    }
                    this.func_110594_c(s);
                }
            }
            return set;
        }
    }

    public static class Jar
    extends FileResourcePack {
        private AnimaniaAddon addon;
        private ZipFile resourcePackZipFile;
        public List<ResourceLocation> manualFiles = new ArrayList<ResourceLocation>();

        public Jar(AnimaniaAddon addon) {
            super(AddonResourcePack.getAddonFile(addon));
            this.addon = addon;
        }

        public String func_130077_b() {
            return "AnimaniaAddonResourcePack:" + this.addon.getAddonID();
        }

        public boolean func_110593_b(String name) {
            try {
                return this.getResourcePackZipFile().getEntry(name.replace("assets/", "assets/" + this.addon.getAddonID() + "/")) != null;
            }
            catch (IOException var3) {
                var3.printStackTrace();
                return false;
            }
        }

        public Set<String> func_110587_b() {
            ZipFile zipfile;
            this.manualFiles.clear();
            try {
                zipfile = this.getResourcePackZipFile();
            }
            catch (IOException var8) {
                var8.printStackTrace();
                return Collections.emptySet();
            }
            Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
            HashSet set = Sets.newHashSet();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipentry = enumeration.nextElement();
                String s = zipentry.getName();
                if (!s.startsWith("assets/" + this.addon.getAddonID() + "/")) continue;
                String[] list = s.split("/");
                if (s.contains("/manual/") && s.endsWith(".json")) {
                    String resLoc = s.substring(s.indexOf("manual"), s.length());
                    ResourceLocation loc = new ResourceLocation("animania", resLoc.replace("\\", "/"));
                    this.manualFiles.add(loc);
                }
                if (list.length != 3) continue;
                String s1 = list[2];
                if (s1.equals(s1.toLowerCase(Locale.ROOT))) {
                    set.add(s1);
                    continue;
                }
                this.func_110594_c(s1);
            }
            return set;
        }

        protected InputStream func_110591_a(String resourceName) throws IOException {
            if (resourceName.contains("pack.mcmeta")) {
                return Animania.class.getResourceAsStream("/addons.mcmeta");
            }
            resourceName = resourceName.replace("assets/", "assets/" + this.addon.getAddonID() + "/");
            return super.func_110591_a(resourceName);
        }

        private ZipFile getResourcePackZipFile() throws IOException {
            if (this.resourcePackZipFile == null) {
                this.resourcePackZipFile = new ZipFile(this.field_110597_b);
            }
            return this.resourcePackZipFile;
        }
    }
}

