/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.effects.MatterCannonFX;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketMatterCannon
extends AppEngPacket {
    private final double x;
    private final double y;
    private final double z;
    private final double dx;
    private final double dy;
    private final double dz;
    private final byte len;

    public PacketMatterCannon(ByteBuf stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.dx = stream.readFloat();
        this.dy = stream.readFloat();
        this.dz = stream.readFloat();
        this.len = stream.readByte();
    }

    public PacketMatterCannon(double x, double y, double z, float dx, float dy, float dz, byte len) {
        float dl = dx * dx + dy * dy + dz * dz;
        float dlz = (float)Math.sqrt(dl);
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx / dlz;
        this.dy = dy / dlz;
        this.dz = dz / dlz;
        this.len = len;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        data.writeFloat((float)this.dx);
        data.writeFloat((float)this.dy);
        data.writeFloat((float)this.dz);
        data.writeByte((int)len);
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        try {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            for (int a = 1; a < this.len; ++a) {
                MatterCannonFX fx = new MatterCannonFX((World)world, this.x + this.dx * (double)a, this.y + this.dy * (double)a, this.z + this.dz * (double)a, Items.field_151045_i);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

