/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlEvent;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.client.gui.controls.GuiAnimationViewer;
import com.creativemd.littletiles.client.gui.controls.IAnimationControl;
import com.creativemd.littletiles.client.world.LittleAnimationHandlerClient;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class GuiTileViewer
extends GuiParent
implements IAnimationControl {
    public EntityAnimation animation;
    public LittleGridContext context;
    public LittleVec size;
    public LittleVec min;
    public SmoothValue scale = new SmoothValue(200L, 40.0);
    public SmoothValue offsetX = new SmoothValue(100L);
    public SmoothValue offsetY = new SmoothValue(100L);
    private EnumFacing viewDirection;
    public boolean visibleAxis = false;
    public boolean visibleNormalAxis = false;
    private EnumFacing.Axis normalAxis;
    private EnumFacing.Axis axisDirection;
    private EnumFacing xFacing;
    private EnumFacing yFacing;
    private EnumFacing zFacing;
    public SmoothValue rotX = new SmoothValue(400L);
    public SmoothValue rotY = new SmoothValue(400L);
    public SmoothValue rotZ = new SmoothValue(400L);
    private LittleBox box;
    private LittleGridContext axisContext;
    private boolean even;
    public boolean grabbed = false;
    public Vec3d lastPosition;

    public LittleBox getBox() {
        return this.box;
    }

    public LittleGridContext getAxisContext() {
        return this.axisContext;
    }

    public void setAxis(LittleBox box, LittleGridContext context) {
        this.box = box.copy();
        this.axisContext = context;
        this.raiseEvent((ControlEvent)new GuiTileViewerAxisChangedEvent((GuiControl)this));
    }

    public boolean isEven() {
        return this.even;
    }

    public void setEven(boolean even) {
        boolean changed = this.even != even;
        this.even = even;
        if (!changed || this.box == null) {
            return;
        }
        if (even) {
            --this.box.minX;
            --this.box.minY;
            --this.box.minZ;
        } else {
            ++this.box.minX;
            ++this.box.minY;
            ++this.box.minZ;
        }
        this.raiseEvent((ControlEvent)new GuiTileViewerAxisChangedEvent((GuiControl)this));
    }

    public GuiTileViewer(String name, int x, int y, int width, int height, LittleGridContext context) {
        super(name, x, y, width, height);
        this.context = context;
        this.marginWidth = 0;
        this.setViewAxis(EnumFacing.Axis.Y);
        this.rotX.setStart(this.rotX.aimed());
        this.rotY.setStart(this.rotY.aimed());
        this.rotZ.setStart(this.rotZ.aimed());
    }

    public void setNormalAxis(EnumFacing.Axis normalAxis) {
        this.normalAxis = normalAxis;
    }

    public EnumFacing.Axis getNormalAxis() {
        return this.normalAxis;
    }

    public EnumFacing getViewDirection() {
        return this.viewDirection;
    }

    public void setViewDirection(EnumFacing facing) {
        this.viewDirection = facing;
        this.updateNormalAxis();
        switch (facing.func_176734_d()) {
            case EAST: {
                this.rotX.set(0.0);
                this.rotY.set(-90.0);
                this.rotZ.set(0.0);
                break;
            }
            case WEST: {
                this.rotX.set(0.0);
                this.rotY.set(90.0);
                this.rotZ.set(0.0);
                break;
            }
            case UP: {
                this.rotX.set(90.0);
                this.rotY.set(0.0);
                this.rotZ.set(0.0);
                break;
            }
            case DOWN: {
                this.rotX.set(-90.0);
                this.rotY.set(0.0);
                this.rotZ.set(0.0);
                break;
            }
            case SOUTH: {
                this.rotX.set(0.0);
                this.rotY.set(-180.0);
                this.rotZ.set(0.0);
                break;
            }
            case NORTH: {
                this.rotX.set(0.0);
                this.rotY.set(0.0);
                this.rotZ.set(0.0);
            }
        }
        Vec3i direction = EnumFacing.EAST.func_176730_m();
        Vector3d vec = new Vector3d((double)direction.func_177958_n(), (double)direction.func_177956_o(), (double)direction.func_177952_p());
        this.transform(vec);
        if (vec.x != 0.0) {
            this.xFacing = vec.x < 0.0 ? EnumFacing.EAST : EnumFacing.WEST;
        } else if (vec.y != 0.0) {
            this.yFacing = vec.y < 0.0 ? EnumFacing.EAST : EnumFacing.WEST;
        } else if (vec.z != 0.0) {
            this.zFacing = vec.z < 0.0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        direction = EnumFacing.UP.func_176730_m();
        vec = new Vector3d((double)direction.func_177958_n(), (double)direction.func_177956_o(), (double)direction.func_177952_p());
        this.transform(vec);
        if (vec.x != 0.0) {
            this.xFacing = vec.x < 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
        } else if (vec.y != 0.0) {
            this.yFacing = vec.y < 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
        } else if (vec.z != 0.0) {
            this.zFacing = vec.z < 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        direction = EnumFacing.SOUTH.func_176730_m();
        vec = new Vector3d((double)direction.func_177958_n(), (double)direction.func_177956_o(), (double)direction.func_177952_p());
        this.transform(vec);
        if (vec.x != 0.0) {
            this.xFacing = vec.x < 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        } else if (vec.y != 0.0) {
            this.yFacing = vec.y < 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        } else if (vec.z != 0.0) {
            this.zFacing = vec.z < 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
    }

    public EnumFacing.Axis getAxis() {
        return this.axisDirection;
    }

    public void setViewAxis(EnumFacing.Axis axis) {
        this.axisDirection = axis;
        this.setViewDirection(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)this.axisDirection));
    }

    public boolean hasMouseOverEffect() {
        return false;
    }

    public void updateNormalAxis() {
        if (this.size == null) {
            return;
        }
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)this.axisDirection);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)this.axisDirection);
        this.normalAxis = this.size.get(one) >= this.size.get(two) ? two : one;
    }

    public void changeNormalAxis() {
        this.normalAxis = RotationUtils.getThird((EnumFacing.Axis)this.axisDirection, (EnumFacing.Axis)this.normalAxis);
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        if (this.animation == null) {
            return;
        }
        GuiAnimationViewer.makeLightBright();
        this.scale.tick();
        this.offsetX.tick();
        this.offsetY.tick();
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)(this.width / 2) - this.offsetX.current()), (double)((double)(this.height / 2) - this.offsetY.current()), (double)0.0);
        GlStateManager.func_179139_a((double)(-this.scale.current()), (double)(-this.scale.current()), (double)(-this.scale.current()));
        GlStateManager.func_179137_b((double)(this.offsetX.current() * 2.0), (double)(this.offsetY.current() * 2.0), (double)0.0);
        GlStateManager.func_179114_b((float)((float)this.rotX.current()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotY.current()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotZ.current()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-this.min.getPosX(this.context)), (double)(-this.min.getPosY(this.context)), (double)(-this.min.getPosZ(this.context)));
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179137_b((double)TileEntityRendererDispatcher.field_147554_b, (double)TileEntityRendererDispatcher.field_147555_c, (double)TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.func_179109_b((float)0.0f, (float)-75.0f, (float)0.0f);
        LittleAnimationHandlerClient.render.doRender(this.animation, 0.0, 0.0, 0.0, 0.0f, TickUtils.getPartialTickTime());
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179084_k();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        if (this.visibleAxis) {
            GlStateManager.func_179094_E();
            RenderBox cube = new RenderBox(this.box.getCube(this.axisContext), Blocks.field_150325_L, 0);
            RenderBox normalCube = new RenderBox((AlignedBox)cube, Blocks.field_150325_L, 0);
            normalCube.minX = (float)((double)normalCube.minX + this.axisContext.pixelSize / 3.0);
            normalCube.minY = (float)((double)normalCube.minY + this.axisContext.pixelSize / 3.0);
            normalCube.minZ = (float)((double)normalCube.minZ + this.axisContext.pixelSize / 3.0);
            normalCube.maxX = (float)((double)normalCube.maxX - this.axisContext.pixelSize / 3.0);
            normalCube.maxY = (float)((double)normalCube.maxY - this.axisContext.pixelSize / 3.0);
            normalCube.maxZ = (float)((double)normalCube.maxZ - this.axisContext.pixelSize / 3.0);
            normalCube.keepVU = true;
            float min = (float)(-10000.0 / this.scale.aimed());
            float max = -min;
            switch (this.normalAxis) {
                case X: {
                    normalCube.minX = min;
                    normalCube.maxX = max;
                    break;
                }
                case Y: {
                    normalCube.minY = min;
                    normalCube.maxY = max;
                    break;
                }
                case Z: {
                    normalCube.minZ = min;
                    normalCube.maxZ = max;
                    break;
                }
            }
            if (this.visibleNormalAxis) {
                normalCube.renderPreview(0.0, 0.0, 0.0, 51);
            }
            cube.renderPreview(0.0, 0.0, 0.0, 255);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        String xAxis = this.getXFacing().func_176740_k().name();
        xAxis = this.getXFacing().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? xAxis + " ->" : "<- " + xAxis;
        String yAxis = this.getYFacing().func_176740_k().name();
        yAxis = this.getYFacing().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? yAxis + " ->" : "<- " + yAxis;
        helper.drawStringWithShadow(xAxis, 0, 0, width, 14, -1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)14.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        helper.drawStringWithShadow(yAxis, 0, 0, width, 14, -1);
        GlStateManager.func_179121_F();
    }

    private void transform(Vector3d vec) {
        Matrix3d matrix = new Matrix3d();
        if (this.rotZ.aimed() != 0.0) {
            matrix.rotZ(Math.toRadians(this.rotZ.aimed()));
            matrix.transform((Tuple3d)vec);
        }
        if (this.rotY.aimed() != 0.0) {
            matrix.rotY(Math.toRadians(this.rotY.aimed()));
            matrix.transform((Tuple3d)vec);
        }
        if (this.rotX.aimed() != 0.0) {
            matrix.rotX(Math.toRadians(this.rotX.aimed()));
            matrix.transform((Tuple3d)vec);
        }
        vec.x = Math.round(vec.x);
        vec.y = Math.round(vec.y);
        vec.z = Math.round(vec.z);
    }

    public EnumFacing getXFacing() {
        return this.xFacing;
    }

    public EnumFacing getYFacing() {
        return this.yFacing;
    }

    public EnumFacing getZFacing() {
        return this.zFacing;
    }

    public void moveX(int distance) {
        this.move(this.getXFacing().func_176740_k(), distance * this.getXFacing().func_176743_c().func_179524_a());
    }

    public void moveY(int distance) {
        this.move(this.getYFacing().func_176740_k(), -distance * this.getYFacing().func_176743_c().func_179524_a());
    }

    protected void move(EnumFacing.Axis axis, int distance) {
        switch (axis) {
            case X: {
                this.box.minX += distance;
                this.box.maxX += distance;
                break;
            }
            case Y: {
                this.box.minY += distance;
                this.box.maxY += distance;
                break;
            }
            case Z: {
                this.box.minZ += distance;
                this.box.maxZ += distance;
                break;
            }
        }
        this.raiseEvent((ControlEvent)new GuiTileViewerAxisChangedEvent((GuiControl)this));
    }

    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        if (scrolled > 0) {
            this.scale.set(this.scale.aimed() * (double)scrolled * 1.5);
        } else if (scrolled < 0) {
            this.scale.set(this.scale.aimed() / ((double)scrolled * -1.5));
        }
        return true;
    }

    public boolean mousePressed(int posX, int posY, int button) {
        this.grabbed = true;
        this.lastPosition = new Vec3d((double)posX, (double)posY, 0.0);
        return true;
    }

    public void mouseMove(int posX, int posY, int button) {
        if (this.grabbed) {
            Vec3d currentPosition = new Vec3d((double)posX, (double)posY, 0.0);
            if (this.lastPosition != null) {
                Vec3d move = this.lastPosition.func_178788_d(currentPosition);
                double percent = 0.5;
                this.offsetX.set(this.offsetX.aimed() + 1.0 / this.scale.aimed() * move.field_72450_a * percent);
                this.offsetY.set(this.offsetY.aimed() + 1.0 / this.scale.aimed() * move.field_72448_b * percent);
            }
            this.lastPosition = currentPosition;
        }
    }

    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbed) {
            this.lastPosition = null;
            this.grabbed = false;
        }
    }

    public boolean onKeyPressed(char character, int key) {
        if (this.isAnyControlFocused() || !this.visibleAxis) {
            return false;
        }
        if (key == 78) {
            this.scale.set(this.scale.aimed() * 2.0);
            return true;
        }
        if (key == 74) {
            this.scale.set(this.scale.aimed() / 2.0);
            return true;
        }
        double percent = 1.0;
        if (key == 17) {
            this.offsetY.set(this.offsetY.aimed() - 1.0 / this.scale.aimed() * percent);
            return true;
        }
        if (key == 31) {
            this.offsetY.set(this.offsetY.aimed() + 1.0 / this.scale.aimed() * percent);
            return true;
        }
        if (key == 32) {
            this.offsetX.set(this.offsetX.aimed() + 1.0 / this.scale.aimed() * percent);
            return true;
        }
        if (key == 30) {
            this.offsetX.set(this.offsetX.aimed() - 1.0 / this.scale.aimed() * percent);
            return true;
        }
        if (key == 200) {
            this.moveY(GuiScreen.func_146271_m() ? this.context.size : 1);
            return true;
        }
        if (key == 208) {
            this.moveY(-(GuiScreen.func_146271_m() ? this.context.size : 1));
            return true;
        }
        if (key == 205) {
            this.moveX(GuiScreen.func_146271_m() ? this.context.size : 1);
            return true;
        }
        if (key == 203) {
            this.moveX(-(GuiScreen.func_146271_m() ? this.context.size : 1));
            return true;
        }
        return false;
    }

    @Override
    public void onLoaded(AnimationPreview animationPreview) {
        this.animation = animationPreview.animation;
        this.size = animationPreview.previews.getSize();
        this.min = animationPreview.previews.getMinVec();
        this.context = animationPreview.previews.getContext();
        this.updateNormalAxis();
    }

    public static class GuiTileViewerAxisChangedEvent
    extends GuiControlEvent {
        public GuiTileViewerAxisChangedEvent(GuiControl source) {
            super(source);
        }

        public boolean isCancelable() {
            return false;
        }
    }
}

