/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxTranslated;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.item.ItemBlockTiles;
import com.creativemd.littletiles.common.item.ItemLittleChisel;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.util.Color;

public class SubGuiChisel
extends SubGuiConfigure {
    public SubGuiChisel(ItemStack stack) {
        super(140, 180, stack);
        this.stack = stack;
    }

    public LittleGridContext getContext() {
        return ((ILittlePlacer)this.stack.func_77973_b()).getPositionContext(this.stack);
    }

    public void createControls() {
        LittlePreview preview = ItemLittleChisel.getPreview(this.stack);
        Color color = ColorUtils.IntToRGBA((int)preview.getColor());
        this.controls.add(new GuiColorPicker("picker", 2, 2, color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        GuiStackSelectorAll selector = new GuiStackSelectorAll("preview", 0, 75, 112, this.getPlayer(), LittleSubGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(preview.getBlockStack());
        this.controls.add(selector);
        GuiComboBoxTranslated box = new GuiComboBoxTranslated("shape", 0, 96, 134, "shape.", new ArrayList<String>(ShapeRegistry.placingShapeNames()));
        box.select(ItemLittleChisel.getShape(this.stack).getKey());
        GuiScrollBox scroll = new GuiScrollBox("settings", 0, 117, 133, 58);
        this.controls.add(box);
        this.controls.add(scroll);
        this.onChange();
        GuiAvatarLabel label = new GuiAvatarLabel("", 115, 35, 0, null);
        label.name = "avatar";
        label.height = 60;
        label.avatarSize = 32;
        this.controls.add(label);
        this.updateLabel();
    }

    @CustomEventSubscribe
    public void onComboBoxChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"shape"})) {
            this.onChange();
        } else if (event.source.is(new String[]{"picker", "preview"})) {
            this.updateLabel();
        }
    }

    public void onChange() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        LittleShape shape = ShapeRegistry.getShape(box.getCaption());
        scroll.controls.clear();
        scroll.controls.addAll(shape.getCustomSettings(this.stack.func_77978_p(), this.getContext()));
        scroll.refreshControls();
    }

    public void updateLabel() {
        LittlePreview preview;
        GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
        ItemStack selected = selector.getSelected();
        if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
            LittleTile tile = new LittleTile(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77960_j());
            tile.setBox(new LittleBox(0, 0, 0, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size));
            preview = tile.getPreviewTile();
        } else {
            preview = ItemLittleChisel.getPreview(this.stack);
        }
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
        GuiAvatarLabel label = (GuiAvatarLabel)this.get("avatar");
        label.avatar = new AvatarItemStack(ItemBlockTiles.getStackFromPreview(LittleGridContext.get(), preview));
    }

    @Override
    public void saveConfiguration() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        LittleShape shape = ShapeRegistry.getShape(box.getCaption());
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        LittlePreview preview = ItemLittleChisel.getPreview(this.stack);
        GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
        ItemStack selected = selector.getSelected();
        if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
            LittleTile tile = new LittleTile(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77960_j());
            tile.setBox(new LittleBox(0, 0, 0, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size));
            preview = tile.getPreviewTile();
        } else {
            preview = ItemLittleChisel.getPreview(this.stack);
        }
        preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
        ItemLittleChisel.setPreview(this.stack, preview);
        ItemLittleChisel.setShape(this.stack, shape);
        shape.saveCustomSettings((GuiParent)scroll, this.stack.func_77978_p(), this.getContext());
    }
}

