/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.energy.ClassicEnergyNet;
import ic2.api.classic.energy.IPacketEnergyNet;
import ic2.api.classic.energy.PacketStat;
import ic2.api.classic.energy.render.IRenderEntry;
import ic2.api.classic.energy.render.IRenderPath;
import ic2.api.classic.energy.render.IRenderValidator;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.tile.ITeleporterTarget;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.block.machine.high.TileEntityTeleporterHub;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricReader
extends ItemIC2
implements ICustomItemCameraTransform,
IEUReader {
    public ItemElectricReader() {
        this.setTranslationKey(Ic2ItemLang.euReader);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public int getTextureEntry(int meta) {
        return 42;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.euReaderModes));
        sortedTooltip.get((Object)ToolTipType.Shift).add(Ic2InfoLang.euReaderToolTips.getLocalized());
        tooltip.add(Ic2InfoLang.euReaderMode.getLocalizedFormatted(MeasuringMode.values()[StackUtil.getNbtData(stack).func_74762_e("Mode")].getName()));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
                int type = nbt.func_74762_e("Mode") + 1;
                if (type >= MeasuringMode.values().length) {
                    type = 0;
                }
                nbt.func_74768_a("Mode", type);
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.euReaderMode.getLocalizedFormatted(MeasuringMode.values()[type].getName()));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            BlockPos pos = playerIn.func_180425_c();
            NBTTagCompound data = StackUtil.getOrCreateNbtData(stack);
            MeasuringMode mode = MeasuringMode.values()[data.func_74762_e("Mode")];
            if (mode == MeasuringMode.RenderArea) {
                EnumActionResult result = ClassicEnergyNet.instance.drawAreaInTiles(worldIn, pos.func_177982_a(-30, -30, -30), pos.func_177982_a(30, 30, 30), playerIn, new AreaOfEffect(false, handIn == EnumHand.OFF_HAND, playerIn.func_180425_c()));
                if (result == EnumActionResult.PASS) {
                    IC2.platform.messagePlayer(playerIn, Ic2Lang.nothingHappend);
                } else if (result == EnumActionResult.FAIL) {
                    IC2.platform.messagePlayer(playerIn, Ic2InfoLang.euReaderCantFindPath);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (mode == MeasuringMode.RenderAreaReverse) {
                EnumActionResult result = ClassicEnergyNet.instance.drawAreaInTiles(worldIn, pos.func_177982_a(-30, -30, -30), pos.func_177982_a(30, 30, 30), playerIn, new AreaOfEffect(true, handIn == EnumHand.OFF_HAND, playerIn.func_180425_c()));
                if (result == EnumActionResult.PASS) {
                    IC2.platform.messagePlayer(playerIn, Ic2Lang.nothingHappend);
                } else if (result == EnumActionResult.FAIL) {
                    IC2.platform.messagePlayer(playerIn, Ic2InfoLang.euReaderCantFindPath);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (IC2.platform.isSimulating() && !IC2.keyboard.isModeSwitchKeyDown(player)) {
            IPacketEnergyNet packetNet = ClassicEnergyNet.instance;
            IEnergyTile energyTile = packetNet.getTile(world, pos);
            NBTTagCompound data = StackUtil.getOrCreateNbtData(stack);
            MeasuringMode mode = MeasuringMode.values()[data.func_74762_e("Mode")];
            if (energyTile != null) {
                if (energyTile instanceof TileEntityTeleporterHub && player.func_70093_af()) {
                    TileEntityTeleporterHub hub = (TileEntityTeleporterHub)energyTile;
                    IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterHubTargetCount, hub.targets.count());
                    int weight = TileEntityTeleporter.getWeightOfUser((Entity)player);
                    for (Map.Entry<ITeleporterTarget.TeleporterTarget, String> entry : hub.targets) {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterHubTarget, entry.getValue());
                        ITeleporterTarget.TeleporterTarget target = entry.getKey();
                        double distance = Math.sqrt(hub.getDistance(hub.func_174877_v(), target.getPos()));
                        int distanceCost = (int)(Math.pow(distance + 10.0, target.getDimID() != world.field_73011_w.getDimension() ? 0.9 : 0.7) * 5.0 * (double)weight);
                        IC2.platform.messagePlayer(player, Arrays.asList(new Tuple((Object)Ic2InfoLang.euReaderTeleporterHubTargetDistance, (Object)new Object[]{(int)distance}), new Tuple((Object)Ic2InfoLang.euReaderTeleporterHubTargetCost, (Object)new Object[]{distanceCost})));
                    }
                    return EnumActionResult.SUCCESS;
                }
                DecimalFormat powerFormat = Ic2Formatters.stackFormat;
                if (mode == MeasuringMode.EUAverageReading) {
                    NodeStats node = packetNet.getNodeStats(energyTile);
                    double currentTotalEnergyEmitted = node.getEnergyOut();
                    double currentTotalEnergySunken = node.getEnergyIn();
                    long currentMeasureTime = world.func_82737_E();
                    if (data.func_74762_e("lastMeasuredTileEntityX") != pos.func_177958_n() || data.func_74762_e("lastMeasuredTileEntityY") != pos.func_177956_o() || data.func_74762_e("lastMeasuredTileEntityZ") != pos.func_177952_p()) {
                        data.func_74768_a("lastMeasuredTileEntityX", pos.func_177958_n());
                        data.func_74768_a("lastMeasuredTileEntityY", pos.func_177956_o());
                        data.func_74768_a("lastMeasuredTileEntityZ", pos.func_177952_p());
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderStartNewMeasuring);
                    } else {
                        long measurePeriod = currentMeasureTime - data.func_74763_f("lastMeasureTime");
                        if (measurePeriod < 1L) {
                            measurePeriod = 1L;
                        }
                        double deltaEmitted = (currentTotalEnergyEmitted - data.func_74769_h("lastTotalEnergyEmitted")) / (double)measurePeriod;
                        double deltaSunken = (currentTotalEnergySunken - data.func_74769_h("lastTotalEnergySunken")) / (double)measurePeriod;
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderAverageEU, powerFormat.format(deltaSunken), powerFormat.format(deltaEmitted), powerFormat.format(deltaSunken - deltaEmitted), measurePeriod);
                    }
                    data.func_74780_a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
                    data.func_74780_a("lastTotalEnergySunken", currentTotalEnergySunken);
                    data.func_74772_a("lastMeasureTime", currentMeasureTime);
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.TileInfo) {
                    if (energyTile instanceof IEnergySource) {
                        int offer = (int)((IEnergySource)energyTile).getOfferedEnergy();
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderSourceInfo, offer);
                    }
                    if (energyTile instanceof IEnergySink) {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderSinkInfo, EnergyNetLocal.getMaxEnergyInput((IEnergySink)energyTile));
                    }
                    if (energyTile instanceof IEnergyConductor) {
                        double Powerloss = ((IEnergyConductor)energyTile).getConductionLoss();
                        int conductorBreakdown = (int)((IEnergyConductor)energyTile).getConductorBreakdownEnergy() - 1;
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderCableLoss, Powerloss);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderCableLimit, conductorBreakdown);
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.TotalEmitted) {
                    IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTotalEU, powerFormat.format(packetNet.getNodeStats(energyTile).getEnergyOut()));
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.PacketReading) {
                    List<PacketStat> packets = packetNet.getPackets(energyTile, IPacketEnergyNet.PacketType.Both);
                    long currentMeasureTime = world.func_82737_E();
                    if (data.func_74762_e("lastMeasuredTileEntityX") != pos.func_177958_n() || data.func_74762_e("lastMeasuredTileEntityY") != pos.func_177956_o() || data.func_74762_e("lastMeasuredTileEntityZ") != pos.func_177952_p()) {
                        data.func_74768_a("lastMeasuredTileEntityX", pos.func_177958_n());
                        data.func_74768_a("lastMeasuredTileEntityY", pos.func_177956_o());
                        data.func_74768_a("lastMeasuredTileEntityZ", pos.func_177952_p());
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderStartNewMeasuring);
                    } else {
                        long measurePeriod = currentMeasureTime - data.func_74763_f("lastMeasureTime");
                        if (measurePeriod < 1L) {
                            measurePeriod = 1L;
                        }
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderAveragePacket, measurePeriod);
                        if (packets.isEmpty()) {
                            IC2.platform.messagePlayer(player, Ic2Lang.nothingComp);
                        } else {
                            for (PacketStat stat : packets) {
                                IC2.platform.messagePlayer(player, stat.isEmitting() ? Ic2InfoLang.euReaderEmittingPacket : Ic2InfoLang.euReaderReceivingPacket, powerFormat.format(stat.getPacketEnergy()), stat.getPacketCount());
                            }
                        }
                    }
                    data.func_74772_a("lastMeasureTime", currentMeasureTime);
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.TotalPackets) {
                    List<PacketStat> packets = packetNet.getTotalPackets(energyTile, IPacketEnergyNet.PacketType.Both);
                    IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTotalPacket);
                    if (packets.isEmpty()) {
                        IC2.platform.messagePlayer(player, Ic2Lang.nothingComp);
                    } else {
                        for (PacketStat stat : packets) {
                            IC2.platform.messagePlayer(player, stat.isEmitting() ? Ic2InfoLang.euReaderEmittingPacket : Ic2InfoLang.euReaderReceivingPacket, powerFormat.format(stat.getPacketEnergy()), stat.getPacketCount());
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.RenderEmitterPath) {
                    EnumActionResult result = ClassicEnergyNet.instance.drawTile(world, pos, new SinglePosition(false));
                    if (result == EnumActionResult.PASS) {
                        IC2.platform.messagePlayer(player, Ic2Lang.nothingHappend);
                    } else if (result == EnumActionResult.FAIL) {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderCantFindPath);
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (mode == MeasuringMode.RenderReceiverPath) {
                    EnumActionResult result = ClassicEnergyNet.instance.drawTile(world, pos, new SinglePosition(true));
                    if (result == EnumActionResult.PASS) {
                        IC2.platform.messagePlayer(player, Ic2Lang.nothingHappend);
                    } else if (result == EnumActionResult.FAIL) {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderCantFindPath);
                    }
                    return EnumActionResult.SUCCESS;
                }
            } else {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityTeleporter) {
                    TileEntityTeleporter teleport = (TileEntityTeleporter)tile;
                    if (teleport.targetSet) {
                        ITeleporterTarget.TeleportType type = teleport.getSendingType();
                        double distance = teleport.getDistance();
                        int distanceCost = (int)(Math.pow(distance + 10.0, teleport.isDimSwitch() ? 0.9 : 0.7) * 5.0);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterDistance, (int)distance);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterCost, distanceCost);
                        if (type == ITeleporterTarget.TeleportType.Entity) {
                            EntityPlayer target = player;
                            List list = world.func_72872_a(Entity.class, new AxisAlignedBB(pos.func_177984_a()).func_186662_g(1.0));
                            if (list.size() == 1) {
                                target = (Entity)list.get(0);
                            }
                            int weight = TileEntityTeleporter.getWeightOfUser((Entity)target);
                            int cost = weight * distanceCost;
                            IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterEntityWeight, target instanceof EntityPlayer ? "Player" : EntityList.func_75621_b((Entity)target), cost);
                        } else if (type == ITeleporterTarget.TeleportType.Item) {
                            IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterItemWeight);
                        } else if (type == ITeleporterTarget.TeleportType.Fluid) {
                            IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterFluidWeight);
                        } else if (type == ITeleporterTarget.TeleportType.Energy) {
                            IC2.platform.messagePlayer(player, Ic2InfoLang.euReaderTeleporterEnergyWeight);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean isEUReader(ItemStack stack) {
        return true;
    }

    public static class AreaOfEffect
    implements IRenderValidator {
        boolean isReverse;
        boolean hand;
        BlockPos position;

        public AreaOfEffect() {
        }

        public AreaOfEffect(boolean reverse, boolean isOffHand, BlockPos pos) {
            this.isReverse = reverse;
            this.hand = isOffHand;
            this.position = pos;
        }

        @Override
        public boolean isValid(EntityPlayer player) {
            ItemStack stack = player.func_184586_b(this.hand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
            return StackUtil.isStackEqual(stack, Ic2Items.euReader);
        }

        @Override
        public void writeServerData(NBTTagCompound nbt) {
            nbt.func_74757_a("off", this.hand);
            nbt.func_74768_a("x", this.position.func_177958_n());
            nbt.func_74768_a("y", this.position.func_177956_o());
            nbt.func_74768_a("z", this.position.func_177952_p());
        }

        @Override
        public void readClientData(NBTTagCompound nbt) {
            this.hand = nbt.func_74767_n("off");
            this.position = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }

        @Override
        public double getFlowSpeed() {
            return 0.02;
        }

        @Override
        public boolean isReverse() {
            return this.isReverse;
        }

        @Override
        public boolean canRender(EntityPlayer player, IRenderEntry entry) {
            return true;
        }

        @Override
        public void onRenderFinished(EntityPlayer player, IRenderPath path) {
            int distance = (int)Math.sqrt(this.position.func_177951_i((Vec3i)path.getStartingPos()));
            if (distance > 80) {
                return;
            }
            path.resetPaths();
        }
    }

    public static class SinglePosition
    implements IRenderValidator {
        boolean reverse;

        public SinglePosition() {
        }

        public SinglePosition(boolean isReverse) {
            this.reverse = isReverse;
        }

        @Override
        public boolean isValid(EntityPlayer player) {
            return !IC2.keyboard.isHudModeKeyDown(player);
        }

        @Override
        public void writeServerData(NBTTagCompound nbt) {
        }

        @Override
        public void readClientData(NBTTagCompound nbt) {
        }

        @Override
        public double getFlowSpeed() {
            return 0.02;
        }

        @Override
        public boolean isReverse() {
            return this.reverse;
        }

        @Override
        public boolean canRender(EntityPlayer player, IRenderEntry entry) {
            return true;
        }

        @Override
        public void onRenderFinished(EntityPlayer player, IRenderPath path) {
        }
    }

    public static enum MeasuringMode {
        EUAverageReading("measureMode.averageEU.name"),
        TileInfo("measureMode.tileInfo.name"),
        TotalEmitted("measureMode.totalEmitted.name"),
        PacketReading("measureMode.packetReading.name"),
        TotalPackets("measureMode.totalPackets.name"),
        RenderEmitterPath("measureMode.emitPath.name"),
        RenderReceiverPath("measureMode.receivePath.name"),
        RenderArea("measureMode.area.name"),
        RenderAreaReverse("measureMode.areaReverse.name");

        LocaleComp name;

        private MeasuringMode(String par1) {
            this.name = new LangComponentHolder.TranslationComp(par1);
        }

        public LocaleComp getName() {
            return this.name;
        }
    }
}

