/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management;

import ic2.api.recipe.IRecipeInput;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BasicHandlerInstance
implements IItemHandler {
    EnumFacing side;
    InventoryHandler handler;
    List<Integer> slotList;

    public BasicHandlerInstance(InventoryHandler inv, EnumFacing realSide, List<Integer> list) {
        this.handler = inv;
        this.side = realSide;
        this.slotList = list;
    }

    public int getSlots() {
        return this.slotList.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler.getInventory().getStackInSlot(this.slotList.get(slot));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        IHasInventory inv;
        ItemStack invStack;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int realSlot = this.slotList.get(slot);
        if (!this.handler.getAccess(realSlot, this.side).canImport()) {
            return stack;
        }
        IFilter filter = this.handler.getInputFilter(realSlot);
        if (filter != null && !filter.matches(stack)) {
            return stack;
        }
        int maxAllowed = Integer.MAX_VALUE;
        if (this.handler.isForceNoDuplicates()) {
            if (!this.canInsert(realSlot, stack)) {
                return stack;
            }
            maxAllowed = this.getRoom(realSlot, stack);
            if (maxAllowed <= 0) {
                return stack;
            }
        }
        if ((invStack = (inv = this.handler.getInventory()).getStackInSlot(realSlot)).func_190926_b()) {
            int max = Math.min(Math.min(stack.func_77976_d(), inv.getMaxStackSize(realSlot)), maxAllowed);
            if (stack.func_190916_E() <= max) {
                ItemStack copy = stack.func_77946_l();
                if (!simulate) {
                    inv.setStackInSlot(realSlot, copy);
                }
                return ItemStack.field_190927_a;
            }
            ItemStack copy = stack.func_77946_l();
            if (!simulate) {
                inv.setStackInSlot(realSlot, copy.func_77979_a(max));
            } else {
                copy.func_190918_g(max);
            }
            return copy;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) {
            return stack;
        }
        int toAdd = Math.min(Math.min(stack.func_77976_d(), inv.getMaxStackSize(realSlot)), maxAllowed) - invStack.func_190916_E();
        if (toAdd <= 0) {
            return stack;
        }
        if (toAdd > stack.func_190916_E()) {
            if (!simulate) {
                ItemStack copy = invStack.func_77946_l();
                copy.func_190917_f(stack.func_190916_E());
                inv.setStackInSlot(realSlot, copy);
            }
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        if (simulate) {
            copy.func_190918_g(toAdd);
            return copy;
        }
        copy.func_190918_g(toAdd);
        ItemStack realCopy = invStack.func_77946_l();
        realCopy.func_190917_f(toAdd);
        inv.setStackInSlot(realSlot, realCopy);
        return copy;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int realSlot = this.slotList.get(slot);
        if (!this.handler.getAccess(realSlot, this.side).canExport()) {
            return ItemStack.field_190927_a;
        }
        IHasInventory inv = this.handler.getInventory();
        ItemStack stack = inv.getStackInSlot(realSlot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFilter exportFilter = this.handler.getOutputFilter(realSlot);
        if (exportFilter != null && !exportFilter.matches(stack)) {
            return ItemStack.field_190927_a;
        }
        ItemStack split = ItemStack.field_190927_a;
        if (simulate) {
            split = stack.func_77946_l();
            split.func_190920_e(Math.min(stack.func_190916_E(), amount));
        } else {
            split = stack.func_77979_a(amount);
            inv.setStackInSlot(realSlot, stack);
        }
        return split;
    }

    public boolean canInsert(int mySlot, ItemStack toInsert) {
        IHasInventory inv = this.handler.getInventory();
        ItemStack myStack = inv.getStackInSlot(mySlot);
        if (!myStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)myStack, (ItemStack)toInsert)) {
            return false;
        }
        int count = 0;
        boolean allowStack = this.handler.isAllowOnlyOneStack();
        for (Integer slot : this.slotList) {
            ItemStack stack;
            if (slot == mySlot && !allowStack || !StackUtil.isStackEqual(stack = inv.getStackInSlot(slot), toInsert, false, false)) continue;
            count += stack.func_190916_E();
            if (allowStack) continue;
            return false;
        }
        return allowStack ? count < this.getInvLimit(mySlot, this.getLimit(toInsert)) : true;
    }

    public int getRoom(int mySlot, ItemStack toInsert) {
        int count = 0;
        IHasInventory inv = this.handler.getInventory();
        for (Integer slot : this.slotList) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!StackUtil.isStackEqual(stack, toInsert, false, false)) continue;
            count += stack.func_190916_E();
        }
        return this.getInvLimit(mySlot, this.getLimit(toInsert)) - count;
    }

    public Tuple<Integer, Boolean> getLimit(ItemStack stack) {
        for (IRecipeInput input : this.handler.getInputLimits()) {
            if (!input.matches(stack)) continue;
            return new Tuple((Object)input.getAmount(), (Object)true);
        }
        return new Tuple((Object)stack.func_77976_d(), (Object)false);
    }

    public int getInvLimit(int slot, Tuple<Integer, Boolean> limit) {
        if (this.handler.maxStackSizeMod != -1 && !((Boolean)limit.func_76340_b()).booleanValue()) {
            return this.handler.getInputLimit();
        }
        return (Integer)limit.func_76341_a();
    }

    public int getSlotLimit(int slot) {
        return this.handler.getInventory().getMaxStackSize(this.slotList.get(slot));
    }
}

