/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui;

import ic2.core.fluid.LayeredFluidTank;
import ic2.core.inventory.gui.buttons.IToolTipButton;
import ic2.core.inventory.gui.custom.ITooltipSlot;
import ic2.core.inventory.slots.SlotDisplay;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.lang.components.special.VanillaLocaleComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.events.ElectricToolTipManager;
import ic2.core.util.math.Vec2i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class GuiIC2
extends GuiContainer {
    protected Map<Integer, GuiButton> buttonMap = new HashMap<Integer, GuiButton>();
    protected ResourceLocation texture;
    protected LocaleComp name;
    protected List<IToolTipButton> toolTipButtons = new LinkedList<IToolTipButton>();
    protected ITextureObject textureInstance;
    private boolean guiReload = false;
    private boolean showMC = true;
    private boolean showName = true;
    private boolean dissableDisplayToolTips = false;
    Vec2i mcName = Ic2GuiComp.nullVec;
    Vec2i invName = Ic2GuiComp.nullVec;

    public GuiIC2(Container container, ResourceLocation tex) {
        this(container);
        this.setGuiTexture(tex);
    }

    public GuiIC2(Container container) {
        super(container);
    }

    public void setGuiTexture(ResourceLocation tex) {
        this.texture = tex;
    }

    public void setGuiName(String guiName) {
        this.setGuiName(new DisplayLocaleComp(guiName));
    }

    public void setTranslatedGuiName(String guiName) {
        this.setGuiName(new VanillaLocaleComponent(guiName));
    }

    public void setGuiName(LocaleComp comp) {
        this.name = comp;
    }

    public void registerButton(GuiButton button) {
        this.field_146292_n.add(button);
        this.buttonMap.put(button.field_146127_k, button);
        if (button instanceof IToolTipButton) {
            this.toolTipButtons.add((IToolTipButton)button);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textureInstance = this.getTexture(this.texture);
        this.field_146292_n.clear();
        this.buttonMap.clear();
        this.toolTipButtons.clear();
        for (Slot slot : this.field_147002_h.field_75151_b) {
            IToolTipButton provider;
            if (!(slot instanceof ITooltipSlot) || (provider = ((ITooltipSlot)slot).getTooltipProvider()) == null) continue;
            this.toolTipButtons.add(provider);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.guiReload) {
            this.func_73866_w_();
            this.guiReload = false;
        }
        this.onGuiTick();
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.onPostDraw(mouseX, mouseY, partialTicks);
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        ArrayList<String> text = new ArrayList<String>();
        for (IToolTipButton button : this.toolTipButtons) {
            button.addToolTips(this, x, y, text);
        }
        this.onToolTipCollection(mouseX, mouseY, text);
        if (text.size() > 0) {
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
            ElectricToolTipManager.cancelState = 2;
        }
    }

    public void onGuiTick() {
    }

    public void onPostDraw(int mouseX, int mouseY, float ticks) {
    }

    public void onToolTipCollection(int mouseX, int mouseY, List<String> list) {
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.showName) {
            this.drawCenteredString(this.name, this.field_146999_f / 2 + this.invName.getX(), 6 + this.invName.getY(), 0x404040);
        }
        if (this.showMC) {
            this.drawString(Ic2GuiLang.mcInv, 8 + this.mcName.getX(), this.field_147000_g - 94 + this.mcName.getY(), 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179144_i((int)this.textureInstance.func_110552_b());
        this.func_73729_b(this.getXOffset(), this.getYOffset(), 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void drawString(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x, y, color);
    }

    public void drawString(LocaleComp comp, int x, int y, int color) {
        this.field_146289_q.func_78276_b(comp.getLocalized(), x, y, color);
    }

    public void drawCenteredString(LocaleComp comp, int x, int y, int color) {
        String name = comp.getLocalized();
        int xOffset = x - this.field_146289_q.func_78256_a(name) / 2;
        this.field_146289_q.func_78276_b(name, xOffset, y, color);
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        int xOffset = x - this.field_146289_q.func_78256_a(text) / 2;
        this.field_146289_q.func_78276_b(text, xOffset, y, color);
    }

    public void makeSlotFunction(Slot slot) {
        int i = slot.field_75223_e + this.field_147003_i;
        int j = slot.field_75221_f + this.field_147009_r;
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (!slot.func_75216_d()) {
            TextureAtlasSprite textureatlassprite = slot.getBackgroundSprite();
            if (textureatlassprite != null) {
                GlStateManager.func_179140_f();
                this.field_146297_k.func_110434_K().func_110577_a(slot.getBackgroundLocation());
                this.func_175175_a(i, j, textureatlassprite, 16, 16);
                GlStateManager.func_179145_e();
            }
        } else {
            ItemStack stack = slot.func_75211_c();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, stack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, i, j, null);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (this.dissableDisplayToolTips && this.getSlotUnderMouse() instanceof SlotDisplay) {
            return;
        }
        super.func_146285_a(stack, x, y);
    }

    public void displayMultiGaugge(int j, int k, int xOver, int yOver, int line, int col, ITextureObject texture, LayeredFluidTank tank) {
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        TextureMap map = this.field_146297_k.func_147117_R();
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int start = 0;
        IFluidTankProperties[] props = tank.getTankProperties();
        int max = tank.getCapacity();
        for (int i = 0; i < props.length; ++i) {
            int x;
            FluidStack stack;
            int lvl;
            if (props[i] == null || (lvl = (int)((stack = props[i].getContents()) == null ? 0.0 : (double)stack.amount / (double)max * 58.0)) == 0) continue;
            TextureAtlasSprite liquidIcon = null;
            Fluid fluid = stack.getFluid();
            if (fluid != null && fluid.getStill() != null) {
                liquidIcon = map.func_110572_b(fluid.getStill().toString());
            }
            if (liquidIcon == null) continue;
            int color = fluid.getColor(stack);
            GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 0 & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            do {
                if (lvl > 16) {
                    x = 16;
                    lvl -= 16;
                } else {
                    x = lvl;
                    lvl = 0;
                }
                this.func_175175_a(j + col, k + line + 58 - x - start, liquidIcon, 16, 16 - (16 - x));
                start += x;
            } while (x != 0 && lvl != 0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179144_i((int)texture.func_110552_b());
        this.func_73729_b(j + col, k + line, xOver, yOver, 16, 60);
    }

    public void displayGauge(int j, int k, int xOver, int yOver, int line, int col, int squaled, ITextureObject texture, FluidStack liquid) {
        if (liquid == null) {
            return;
        }
        int start = 0;
        TextureMap map = this.field_146297_k.func_147117_R();
        TextureAtlasSprite liquidIcon = null;
        Fluid fluid = liquid.getFluid();
        if (fluid != null && fluid.getStill() != null) {
            liquidIcon = map.func_110572_b(fluid.getStill().toString());
        }
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getColor(liquid);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 0 & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        if (liquidIcon != null) {
            int x;
            do {
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.func_175175_a(j + col, k + line + 58 - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179144_i((int)texture.func_110552_b());
        this.func_73729_b(j + col, k + line, xOver, yOver, 16, 60);
    }

    public void setMaxGuiXY(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    public void setMaxGuiX(int x) {
        this.field_146999_f = x;
    }

    public void setMaxGuiY(int y) {
        this.field_147000_g = y;
    }

    public void setZLevel(int z) {
        this.field_73735_i = z;
    }

    public void dissableInvName() {
        this.showMC = false;
    }

    public void disableName() {
        this.showName = false;
    }

    public void dissableTooltipsOnDisplays() {
        this.dissableDisplayToolTips = true;
    }

    public void preventDoubleClick() {
        try {
            ReflectionHelper.setPrivateValue(GuiContainer.class, (Object)((Object)this), (Object)0L, (String)"field_146992_L", (String)"lastClickButton");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInvOffset(Vec2i offset) {
        this.invName = offset;
    }

    public void setMCOffset(Vec2i offset) {
        this.mcName = offset;
    }

    public void requestGuiReload() {
        this.guiReload = true;
    }

    public ResourceLocation getGuiTexture() {
        return this.texture;
    }

    public ITextureObject getTextureObject() {
        return this.textureInstance;
    }

    public RenderItem getRenderItem() {
        return this.field_146296_j;
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public boolean isSlotDragging() {
        return this.field_147007_t;
    }

    public GuiButton getButton(int id) {
        return this.buttonMap.get(id);
    }

    public <T extends GuiButton> T getCastedButton(int id, Class<T> clz) {
        return (T)this.buttonMap.get(id);
    }

    public boolean hasButton(int id) {
        return this.buttonMap.containsKey(id);
    }

    public boolean isSlotHovered(Slot slot, int mouseX, int mouseY) {
        return this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
    }

    public int getXOffset() {
        return this.field_147003_i;
    }

    public int getYOffset() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public int getZLevel() {
        return (int)this.field_73735_i;
    }

    public <T extends Container> T getContainer(Class<T> clz) {
        if (clz.isInstance(this.field_147002_h)) {
            return (T)this.field_147002_h;
        }
        return null;
    }

    public String getGuiName() {
        return this.name.getLocalized();
    }

    public EntityPlayer getPlayer() {
        return this.field_146297_k.field_71439_g;
    }

    public UUID getPlayerID() {
        return this.field_146297_k.field_71439_g.func_110124_au();
    }

    public ITextureObject getTexture(ResourceLocation location) {
        ITextureObject texture = this.field_146297_k.field_71446_o.func_110581_b(location);
        if (texture == null) {
            texture = new SimpleTexture(location);
            this.field_146297_k.field_71446_o.func_110579_a(location, texture);
        }
        return texture;
    }
}

