/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorPersonalTank;
import ic2.core.block.personal.base.TileEntityPersonalStorageBase;
import ic2.core.block.personal.base.misc.FilteredPersonalInventory;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.IPersonalTank;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.container.ContainerPersonalTank;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.FluidContainerFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.IItemContainer;
import ic2.core.util.obj.ITankListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityPersonalTank
extends TileEntityPersonalStorageBase
implements IPersonalTank,
ITickable,
ITankListener,
IItemContainer,
IClickable,
IPersonalBlock {
    @NetworkField(index=7)
    public IC2Tank tank = new IC2Tank(128000);
    public PersonalInventory inv = new FilteredPersonalInventory(4).addFilters(CommonFilters.Nothing, 1, 3).addFilters(new FluidContainerFilter(false), 0).addFilters(new FluidContainerFilter((IFluidHandler)this.tank), 2);

    public TileEntityPersonalTank() {
        this.tank.addListener(this);
        this.addGuiFields("tank");
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorPersonalTank(this));
    }

    @Override
    public boolean allowExtraction() {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.personalTank;
    }

    @Override
    public void onChange(int type) {
        if (type == 1) {
            this.tank.setFluid(null);
            this.inv.clear();
            this.onTankChanged((IFluidTank)this.tank);
        } else if (type == 2) {
            this.tank.setCanFill(this.allowInjection);
        } else if (type == 3) {
            this.tank.setCanDrain(this.allowExtraction);
        }
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "tank");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.allowInjection || this.allowExtraction;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.allowExtraction || this.allowInjection) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IFluidHandler getTank(UUID user) {
        if (this.canAccess(user)) {
            return this.tank;
        }
        return null;
    }

    @Override
    public boolean canRemoveBlockProbe(EntityPlayer player) {
        if (!this.canAccess(player.func_110124_au())) {
            return false;
        }
        return this.inv.isInvEmpty();
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        if (!this.canAccess(player.func_110124_au())) {
            return false;
        }
        if (!this.inv.isInvEmpty()) {
            IC2.platform.messagePlayer(player, Ic2InfoLang.wrenchCantPick);
            return false;
        }
        return true;
    }

    @Override
    public void loadFromState(int state) {
        super.loadFromState(state);
        this.tank.setCanDrain(this.allowExtraction);
        this.tank.setCanFill(this.allowInjection);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt.func_74775_l("TankInv"));
        this.tank.readFromNBT(nbt.func_74775_l("Tank"));
        this.tank.setCanDrain(this.allowExtraction);
        this.tank.setCanFill(this.allowInjection);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.tank.writeToNBT(this.getTag(nbt, "Tank"));
        this.inv.writeToNBT(this.getTag(nbt, "TankInv"));
        return nbt;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getPixel() {
        return (int)((double)this.tank.getFluidAmount() / (double)this.tank.getCapacity() * 58.0);
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_73660_a() {
        ItemStack added;
        PersonalInventory output;
        IItemTransporter trans;
        Tuple<ItemStack, FluidStack> filled;
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (!this.inv.getStackInSlot(0).func_190926_b()) {
            PersonalInventory output2 = this.inv.copy(1, 2);
            this.tank.setCanFill(true);
            if (FluidHelper.drainContainers((IFluidHandler)this.tank, this.inv, 0, output2)) {
                this.getNetwork().updateTileGuiField(this, "tank");
                this.inv.setStackInSlot(1, output2.getStackInSlot(0));
            }
            this.tank.setCanFill(this.allowInjection);
        }
        if (!this.inv.getStackInSlot(2).func_190926_b() && this.tank.getFluidAmount() > 0 && (filled = FluidHelper.fillContainer(this.inv.getStackInSlot(2), this.tank.getFluid(), true, true)) != null && (trans = TransporterManager.manager.getTransporter(output = this.inv.copy(3, 4), false)) != null && !(added = trans.addItem((ItemStack)filled.func_76341_a(), null, true)).func_190926_b()) {
            this.inv.setStackInSlot(3, output.getStackInSlot(0));
            this.inv.getStackInSlot(2).func_190918_g(1);
            this.tank.drainInternal((FluidStack)filled.func_76340_b(), true);
            this.getNetwork().updateTileGuiField(this, "tank");
        }
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        if (!this.canAccess(player.func_110124_au())) {
            ItemStack result;
            ItemStack playerStack;
            if (this.allowInjection && !(playerStack = player.func_184586_b(hand)).func_190926_b() && !(result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.tank, (int)(this.tank.getCapacity() - this.tank.getFluidAmount()), (EntityPlayer)player, (boolean)true).getResult()).func_190926_b()) {
                playerStack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
                return true;
            }
            return !this.allowView;
        }
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b()) {
            ItemStack result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.tank, (int)(this.tank.getCapacity() - this.tank.getFluidAmount()), (EntityPlayer)player, (boolean)true).getResult();
            if (!result.func_190926_b()) {
                playerStack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
                return true;
            }
            result = FluidHelper.fillContainer(playerStack, this.tank.getFluid(), true, true, true);
            if (!result.func_190926_b()) {
                FluidStack fluid;
                playerStack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
                if ((fluid = this.tank.getFluid()) != null) {
                    SoundEvent soundevent = fluid.getFluid().getFillSound(fluid);
                    player.func_184185_a(soundevent, 1.0f, 1.0f);
                }
                if (this.tank.getFluidAmount() <= 0) {
                    this.tank.setFluid(null);
                }
                this.getNetwork().updateTileGuiField(this, "tank");
                return true;
            }
        }
        return false;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au())) {
            return new ContainerPersonalTank(player.field_71071_by, this, false);
        }
        if (this.allowView) {
            return new ContainerPersonalTank(player.field_71071_by, this, true);
        }
        return null;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au()) || this.allowView) {
            return GuiComponentContainer.class;
        }
        return null;
    }

    @Override
    public List<ItemStack> getDrops() {
        NBTTagCompound nbt;
        int value;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack result = Ic2Items.personalTank.func_77946_l();
        if (this.tank.getFluid() != null) {
            StackUtil.getOrCreateNbtData(result).func_74782_a("Fluid", (NBTBase)this.tank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if ((value = this.getValue()) != 0) {
            nbt = StackUtil.getOrCreateNbtData(result);
            nbt.func_74774_a("Value", (byte)value);
        }
        if (this.allowView) {
            nbt = StackUtil.getOrCreateNbtData(result);
            nbt.func_74757_a("Allow", this.allowView);
        }
        list.add(result);
        return list;
    }

    @Override
    public IPersonalInventory getInventory(UUID user) {
        if (this.canAccess(user)) {
            return this.inv;
        }
        return null;
    }
}

