/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropCocoa
extends CropCardBase {
    public CropCocoa() {
        super(new CropProperties(3, 1, 3, 0, 4, 0));
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[26];
        }
        return this.getSprite("bc")[15 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Brown", "Food", "Stem"};
    }

    @Override
    public String getId() {
        return "Cocoa";
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151100_aR, 1, 3);
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() <= 3 && cropTile.getTerrainNutrients() >= 3;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((float)humidity * 0.8f + (float)nutrients * 1.3f + (float)air * 0.9f);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 900;
        }
        return 400;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

