/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.configurator.client.gui;

import gcewing.sg.features.configurator.client.gui.GateAddressAccessScreen;
import gcewing.sg.features.configurator.network.ConfiguratorNetworkHandler;
import gcewing.sg.tileentity.SGBaseTE;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GateAddressAccessEntryScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private BasicForm form;
    private UITextField addressTextField;
    private EntityPlayer player;
    public int function;
    public String oldAddress;
    public String newAddress;
    private SGBaseTE localGate;

    public GateAddressAccessEntryScreen(BasicScreen parent, EntityPlayer player, SGBaseTE localGate, String oldAddress, String newAddress, int function) {
        super((GuiScreen)parent, true);
        this.player = player;
        this.oldAddress = oldAddress;
        this.newAddress = newAddress;
        this.function = function;
        this.localGate = localGate;
    }

    public void construct() {
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        this.form = new BasicForm((MalisisGui)this, 180, 100, "");
        this.form.setAnchor(Anchor.CENTER | Anchor.MIDDLE);
        this.form.setMovable(true);
        this.form.setClosable(true);
        this.form.setBorder(0xFFFFFF, 1, 185);
        this.form.setBackgroundAlpha(255);
        this.form.setBottomPadding(3);
        this.form.setRightPadding(3);
        this.form.setTopPadding(20);
        this.form.setLeftPadding(3);
        UILabel titleLabel = new UILabel((MalisisGui)this, "");
        titleLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        titleLabel.setPosition(0, -15, Anchor.CENTER | Anchor.TOP);
        if (this.function == 1) {
            titleLabel.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.addGateAddress", (Object[])new Object[0]));
        } else if (this.function == 2) {
            titleLabel.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.editGateAddress", (Object[])new Object[0]));
        } else if (this.function == 3) {
            titleLabel.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deleteGateAddress", (Object[])new Object[0]));
        }
        UILabel addressLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.address", (Object[])new Object[0]) + ":");
        addressLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        addressLabel.setPosition(15, 10, Anchor.LEFT | Anchor.TOP);
        this.addressTextField = new UITextField((MalisisGui)this, "", false);
        if (this.oldAddress.isEmpty()) {
            this.addressTextField.setText(this.newAddress);
        } else {
            this.addressTextField.setText(this.oldAddress);
        }
        this.addressTextField.setSize(80, 0);
        this.addressTextField.setPosition(addressLabel.getX() + addressLabel.getWidth() + 10, addressLabel.getY() - 1, Anchor.LEFT | Anchor.TOP);
        this.addressTextField.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        UILabel addressFormatLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.format", (Object[])new Object[0]) + ": XXXX-XXX-XX");
        addressFormatLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).italic(true).shadow(true).scale(0.9f).build());
        addressFormatLabel.setPosition(0, 25, Anchor.CENTER | Anchor.TOP);
        UIButton buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> this.close()).listener((Object)this).build("button.close");
        UIButton buttonDelete = new UIButtonBuilder((MalisisGui)this).width(40).position(-(buttonClose.getX() + buttonClose.getWidth() + 5), 0).visible(this.function == 3).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.delete", (Object[])new Object[0])).onClick(() -> {
            ConfiguratorNetworkHandler.sendGAAEntryUpdateToServer(this.localGate, this.oldAddress, this.addressTextField.getText().trim(), this.function);
            this.close();
        }).listener((Object)this).build("button.delete");
        UIButton buttonSave = new UIButtonBuilder((MalisisGui)this).width(40).position(-(buttonClose.getX() + buttonClose.getWidth() + 5), 0).visible(this.function != 3).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            if (this.addressTextField.getText().length() == 11 && this.addressTextField.getText().substring(4, 5).equalsIgnoreCase("-") && this.addressTextField.getText().substring(8, 9).equalsIgnoreCase("-")) {
                ConfiguratorNetworkHandler.sendGAAEntryUpdateToServer(this.localGate, this.oldAddress, this.addressTextField.getText().trim().toUpperCase(), this.function);
                if (this.parent instanceof GateAddressAccessScreen) {
                    ((GateAddressAccessScreen)this.parent).delayedUpdate();
                }
                this.close();
            } else {
                SGBaseTE.sendErrorMsg(this.player, "invalidFormat", new Object[0]);
            }
        }).listener((Object)this).build("button.save");
        this.form.add(new UIComponent[]{titleLabel, addressLabel, this.addressTextField, addressFormatLabel, buttonDelete, buttonSave, buttonClose});
        this.addToScreen((UIComponent)this.form);
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
            this.addressTextField.setFocused(true);
        }
        if (++this.lastUpdate > 30) {
            if (this.function == 3) {
                this.addressTextField.setEditable(false);
            }
            this.lastUpdate = 0;
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (keyCode == 28) {
            if (this.addressTextField.getText().length() == 9 && this.addressTextField.getText().substring(4, 5).equalsIgnoreCase("-") && this.addressTextField.getText().substring(8, 9).equalsIgnoreCase("-")) {
                ConfiguratorNetworkHandler.sendGAAEntryUpdateToServer(this.localGate, this.oldAddress, this.addressTextField.getText().trim().toUpperCase(), this.function);
                if (this.parent instanceof GateAddressAccessScreen) {
                    ((GateAddressAccessScreen)this.parent).delayedUpdate();
                }
                this.close();
            } else {
                SGBaseTE.sendErrorMsg(this.player, "invalidFormat", new Object[0]);
            }
        }
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }
}

