/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.WaystoneReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WaystonesHandler {
    WaystoneReflect reflector;

    public WaystonesHandler() {
        block2: {
            try {
                this.reflector = new WaystoneReflect();
                CompatUtil.subscribeEventManually(this.reflector.c_GenerateWaystoneNameEvent, this, ReflectUtil.findMethod(this.getClass(), "onGenerateWaystone"));
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup WaystonesHandler!", (Throwable)e);
                ErrorUtil.logSilent("Waystones Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onGenerateWaystone(Event event) {
        if (!ModConfig.server.waystones.removeWaystoneBiome) {
            return;
        }
        try {
            String waystoneName = this.reflector.getWaystoneName(event);
            int dimension = this.reflector.getDimension(event);
            BlockPos waystonePos = this.reflector.getPos(event);
            waystoneName = this.cleanBiome(waystoneName, dimension, waystonePos);
            this.reflector.setWaystoneName(event, waystoneName);
        }
        catch (Exception e) {
            RLTweaker.logger.error("Failed to intercept waystone generation!", (Throwable)e);
        }
    }

    private String cleanBiome(String s, int dimension, BlockPos pos) {
        try {
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null || world.field_72995_K) {
                return s;
            }
            Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (block != Blocks.field_150426_aN) {
                return s;
            }
            String baseName = this.reflector.getRandomName(dimension);
            String result = "" + baseName;
            Set<String> usedNames = this.reflector.getUsedNames(dimension);
            int roman = 1;
            while (usedNames.contains(result)) {
                result = baseName + " " + this.reflector.toRoman(roman);
                ++roman;
            }
            return result;
        }
        catch (Exception e) {
            RLTweaker.logger.error("Failed to intercept waystone generation! Defaulting to uncleaned name for safety.", (Throwable)e);
            return s;
        }
    }
}

