/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.integration.jei.RecipeWrapperIRecipe;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.vat.VatRecipe;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.machine.vat.ContainerVat;
import crazypants.enderio.machines.machine.vat.GuiVat;
import crazypants.enderio.util.Prep;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class VatRecipeCategory
extends BlankRecipeCategory<VatRecipeWrapper> {
    @Nonnull
    public static final String UID = "Vat";
    private static final int xOff = 24;
    private static final int yOff = 9;
    private Rectangle inTankBounds = new Rectangle(6, 3, 15, 47);
    private Rectangle outTankBounds = new Rectangle(108, 3, 15, 47);
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableVatJEIRecipes.get()).booleanValue()) {
            return;
        }
        RecipeWrapperIRecipe.setLevelData(VatRecipeWrapper.class, MachinesPlugin.iGuiHelper, -1, 59, null, null);
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new VatRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.handleRecipes(IRecipe.class, VatRecipeWrapper::new, UID);
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiVat.class, 155, 42, 16, 16, new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_vat.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes(VatRecipeManager.getInstance().getRecipes(), UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerVat.class, UID, ContainerVat.FIRST_RECIPE_SLOT, ContainerVat.NUM_RECIPE_SLOT, ContainerVat.FIRST_INVENTORY_SLOT, ContainerVat.NUM_INVENTORY_SLOT);
    }

    public VatRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("vat");
        this.background = guiHelper.createDrawable(backgroundLocation, 24, 9, 130, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_vat.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull VatRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeWrapper.setCurrentLayout(recipeLayout);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 31, 2);
        guiItemStacks.init(1, true, 80, 2);
        fluidStacks.init(2, true, this.inTankBounds.x, this.inTankBounds.y, this.inTankBounds.width, this.inTankBounds.height, 8000, false, null);
        fluidStacks.init(3, false, this.outTankBounds.x, this.outTankBounds.y, this.outTankBounds.width, this.outTankBounds.height, 8000, false, null);
        group.init(4, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 76, 58, 50, 10, 0, 0);
        guiItemStacks.set(ingredients);
        fluidStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class VatRecipeWrapper
    extends RecipeWrapperIRecipe {
        private IRecipeLayout currentLayout;

        public VatRecipeWrapper(IRecipe rec) {
            super(rec);
        }

        @Override
        public void getIngredients(@Nonnull IIngredients ingredients) {
            super.getIngredients(ingredients);
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(this.recipe.getEnergyRequired()));
        }

        public void setCurrentLayout(IRecipeLayout currentLayout) {
            this.currentLayout = currentLayout;
        }

        @Override
        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.currentLayout != null) {
                VatRecipe.RecipeMatch match;
                IGuiItemStackGroup guiItemStacks = this.currentLayout.getItemStacks();
                IGuiFluidStackGroup fluidStacks = this.currentLayout.getFluidStacks();
                ItemStack in0stack = (ItemStack)((IGuiIngredient)guiItemStacks.getGuiIngredients().get(0)).getDisplayedIngredient();
                ItemStack in1Stack = (ItemStack)((IGuiIngredient)guiItemStacks.getGuiIngredients().get(1)).getDisplayedIngredient();
                FluidStack fluidIn = (FluidStack)((IGuiIngredient)fluidStacks.getGuiIngredients().get(2)).getDisplayedIngredient();
                if (in0stack != null && fluidIn != null && (match = ((VatRecipe)this.recipe).matchRecipe(fluidIn, in0stack, in1Stack != null ? in1Stack : Prep.getEmpty())) != null) {
                    fluidStacks.set(2, match.in);
                    fluidStacks.set(3, match.out);
                    minecraft.field_71466_p.func_78276_b("x" + match.r0.getMulitplier(), 30, 22, 0x808080);
                    minecraft.field_71466_p.func_78276_b("x" + match.r1.getMulitplier(), 80, 22, 0x808080);
                }
            }
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }
    }
}

