/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.teleport;

import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundRegistry;

public enum TravelSource {
    BLOCK(SoundRegistry.TRAVEL_SOURCE_BLOCK){

        @Override
        public int getMaxDistanceTravelled() {
            return (Integer)TeleportConfig.rangeBlocks.get();
        }
    }
    ,
    STAFF(SoundRegistry.TRAVEL_SOURCE_ITEM){

        @Override
        public int getMaxDistanceTravelled() {
            return (Integer)TeleportConfig.rangeItem2Block.get();
        }

        @Override
        public float getPowerCostPerBlockTraveledRF() {
            return ((Float)TeleportConfig.costItem2Block.get()).floatValue();
        }
    }
    ,
    STAFF_BLINK(SoundRegistry.TRAVEL_SOURCE_ITEM){

        @Override
        public int getMaxDistanceTravelled() {
            return (Integer)TeleportConfig.rangeItem2Blink.get();
        }

        @Override
        public float getPowerCostPerBlockTraveledRF() {
            return ((Float)TeleportConfig.costItem2Blink.get()).floatValue();
        }
    }
    ,
    TELEPAD(SoundRegistry.TELEPAD);

    public final IModSound sound;

    public static int getMaxDistanceSq() {
        int result = 0;
        for (TravelSource source : TravelSource.values()) {
            if (source.getMaxDistanceTravelled() <= result) continue;
            result = source.getMaxDistanceTravelled();
        }
        return result * result;
    }

    private TravelSource(IModSound sound) {
        this.sound = sound;
    }

    public boolean getConserveMomentum() {
        return this == STAFF_BLINK;
    }

    public int getMaxDistanceTravelled() {
        return 0;
    }

    public int getMaxDistanceTravelledSq() {
        return this.getMaxDistanceTravelled() * this.getMaxDistanceTravelled();
    }

    public float getPowerCostPerBlockTraveledRF() {
        return 0.0f;
    }
}

