/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraftforge/client/model/ModelLoader$VariantLoader"})
@ClientOnlyMixin
public class MixinVariantLoader {
    private Cache<ResourceLocation, ModelBlockDefinition> modelBlockDefinitionCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).concurrencyLevel(8).softValues().build();
    private static final MethodHandle WEIGHTED_CONSTRUCTOR;
    private static final MethodHandle MULTIPART_CONSTRUCTOR;

    @Inject(method={"onResourceManagerReload"}, at={@At(value="HEAD")})
    private void onReload(IResourceManager manager, CallbackInfo ci) {
        this.modelBlockDefinitionCache.invalidateAll();
    }

    private VariantList normalizeAndGetVariant(ModelBlockDefinition definition, String variant) {
        if (definition.func_188000_b(variant)) {
            return definition.func_188004_c(variant);
        }
        if (variant.equals("normal") && definition.func_188000_b("")) {
            return definition.func_188004_c("");
        }
        return null;
    }

    @Overwrite(remap=false)
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        ModelResourceLocation variant = (ModelResourceLocation)modelLocation;
        ModelBlockDefinition definition = this.vfix$getModelBlockDefinition((ResourceLocation)variant);
        VariantList vList = this.normalizeAndGetVariant(definition, variant.func_177518_c());
        if (vList != null) {
            try {
                return WEIGHTED_CONSTRUCTOR.invoke(variant, vList);
            }
            catch (Throwable e) {
                throw (Exception)e;
            }
        }
        if (definition.func_188002_b()) {
            ResourceLocation baseLocation = new ResourceLocation(variant.func_110624_b(), variant.func_110623_a());
            Block block = ModelLocationInformation.getBlockFromBlockstateLocation(baseLocation);
            if (!ModelLocationInformation.isAppropriateMultipart(baseLocation, variant)) {
                throw new Exception("Not valid multipart for " + block + ": " + variant);
            }
            if (block != null) {
                definition.func_188001_c().func_188138_a(block.func_176194_O());
            }
        }
        try {
            return MULTIPART_CONSTRUCTOR.invoke(new ResourceLocation(variant.func_110624_b(), variant.func_110623_a()), definition.func_188001_c());
        }
        catch (Throwable e) {
            throw (Exception)e;
        }
    }

    private ModelBlockDefinition vfix$getModelBlockDefinition(ResourceLocation location) {
        ResourceLocation simpleLocation = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        try {
            return (ModelBlockDefinition)this.modelBlockDefinitionCache.get((Object)simpleLocation, () -> ModelLocationInformation.loadModelBlockDefinition(simpleLocation));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    static {
        MethodHandle multipart;
        MethodHandle variant;
        try {
            Class<?> weightedModel = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
            Class<?> multipartModel = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            Constructor<?> weightedC = weightedModel.getConstructor(ResourceLocation.class, VariantList.class);
            Constructor<?> multipartC = multipartModel.getConstructor(ResourceLocation.class, Multipart.class);
            variant = MethodHandles.lookup().unreflectConstructor(weightedC);
            multipart = MethodHandles.lookup().unreflectConstructor(multipartC);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            variant = null;
            multipart = null;
        }
        WEIGHTED_CONSTRUCTOR = variant;
        MULTIPART_CONSTRUCTOR = multipart;
    }
}

