/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.helpers;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import net.minecraft.client.resources.DefaultResourcePack;
import org.embeddedt.vintagefix.dynamicresources.ResourcePackHelper;
import org.embeddedt.vintagefix.util.Util;

public class DefaultPackAdapter
implements ResourcePackHelper.Adapter<DefaultResourcePack> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> walkFileSystems(Class<?> clz, FSConsumer consumer) throws IOException {
        Class<DefaultPackAdapter> clazz = DefaultPackAdapter.class;
        synchronized (DefaultPackAdapter.class) {
            FileSystem mainFs;
            block17: {
                try {
                    URI uri = clz.getResource("/assets/.mcassetsroot").toURI();
                    if ("jar".equals(uri.getScheme())) {
                        try {
                            mainFs = FileSystems.getFileSystem(uri);
                        }
                        catch (FileSystemNotFoundException var11) {
                            mainFs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        }
                        break block17;
                    }
                    throw new IOException("Wrong URI scheme: " + uri.getScheme());
                }
                catch (URISyntaxException e) {
                    throw new IOException("Couldn't list vanilla resources", e);
                }
            }
            HashSet<String> set = new HashSet<String>(consumer.accept(mainFs));
            mainFs.close();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (clz.getClassLoader() instanceof URLClassLoader) {
                URLClassLoader cl = (URLClassLoader)clz.getClassLoader();
                for (URL url : cl.getURLs()) {
                    Object newList = ImmutableList.of();
                    try {
                        FileSystem fs;
                        URI uri = new URI("jar", url.toURI().toString(), null);
                        boolean needClose = false;
                        try {
                            fs = FileSystems.getFileSystem(uri);
                        }
                        catch (FileSystemNotFoundException e) {
                            fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                            needClose = true;
                        }
                        try {
                            newList = consumer.accept(fs);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (newList.size() > 0) {
                            set.addAll((Collection<String>)newList);
                        }
                        if (!needClose) continue;
                        fs.close();
                    }
                    catch (IOException | RuntimeException | URISyntaxException | ZipError throwable) {
                        // empty catch block
                    }
                }
            }
            return set.iterator();
        }
    }

    @Override
    public Iterator<String> getAllPaths(DefaultResourcePack pack, Predicate<String> filter) throws IOException {
        return DefaultPackAdapter.walkFileSystems(DefaultResourcePack.class, fs -> {
            Path basePath = fs.getPath("/assets", new String[0]);
            try (Stream<Path> stream = Files.walk(basePath, new FileVisitOption[0]);){
                List list = stream.map(basePath::relativize).map(p -> "/assets/" + Util.normalizePathToString(p)).filter(filter).collect(Collectors.toList());
                return list;
            }
        });
    }

    @FunctionalInterface
    private static interface FSConsumer {
        public List<String> accept(FileSystem var1) throws IOException;
    }
}

