/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class ThreePointCircleBrush
extends PerformBrush {
    private Vector coordsOne;
    private Vector coordsTwo;
    private Vector coordsThree;
    private Tolerance tolerance = Tolerance.DEFAULT;

    public ThreePointCircleBrush() {
        this.setName("3-Point Circle");
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.coordsOne == null) {
            this.coordsOne = this.getTargetBlock().getLocation().toVector();
            v.sendMessage(ChatColor.GRAY + "First Corner set.");
        } else if (this.coordsTwo == null) {
            this.coordsTwo = this.getTargetBlock().getLocation().toVector();
            v.sendMessage(ChatColor.GRAY + "Second Corner set.");
        } else if (this.coordsThree == null) {
            this.coordsThree = this.getTargetBlock().getLocation().toVector();
            v.sendMessage(ChatColor.GRAY + "Third Corner set.");
        } else {
            this.coordsOne = this.getTargetBlock().getLocation().toVector();
            this.coordsTwo = null;
            this.coordsThree = null;
            v.sendMessage(ChatColor.GRAY + "First Corner set.");
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.coordsOne == null || this.coordsTwo == null || this.coordsThree == null) {
            return;
        }
        Vector vectorOne = this.coordsTwo.clone();
        vectorOne.subtract(this.coordsOne);
        Vector vectorTwo = this.coordsThree.clone();
        vectorTwo.subtract(this.coordsOne);
        Vector vectorThree = this.coordsThree.clone();
        vectorThree.subtract(vectorTwo);
        if (vectorOne.length() == 0.0 || vectorTwo.length() == 0.0 || vectorThree.length() == 0.0 || vectorOne.angle(vectorTwo) == 0.0f || vectorOne.angle(vectorThree) == 0.0f || vectorThree.angle(vectorTwo) == 0.0f) {
            v.sendMessage(ChatColor.RED + "ERROR: Invalid points, try again.");
            this.coordsOne = null;
            this.coordsTwo = null;
            this.coordsThree = null;
            return;
        }
        Vector normalVector = vectorOne.clone();
        normalVector.crossProduct(vectorTwo);
        double planeConstant = normalVector.getX() * this.coordsOne.getX() + normalVector.getY() * this.coordsOne.getY() + normalVector.getZ() * this.coordsOne.getZ();
        Vector midpointOne = this.coordsOne.getMidpoint(this.coordsTwo);
        Vector midpointTwo = this.coordsOne.getMidpoint(this.coordsThree);
        Vector perpendicularOne = normalVector.clone();
        perpendicularOne.crossProduct(vectorOne);
        Vector perpendicularTwo = normalVector.clone();
        perpendicularTwo.crossProduct(vectorTwo);
        Vector tNumerator = midpointTwo.clone();
        tNumerator.subtract(midpointOne);
        tNumerator.crossProduct(perpendicularTwo);
        Vector tDenominator = perpendicularOne.clone();
        tDenominator.crossProduct(perpendicularTwo);
        double t = tNumerator.length() / tDenominator.length();
        Vector circumcenter = new Vector();
        circumcenter.copy(perpendicularOne);
        circumcenter.multiply(t);
        circumcenter.add(midpointOne);
        Vector brushCenter = new Vector((float)Math.round(circumcenter.getX()), (float)Math.round(circumcenter.getY()), (float)Math.round(circumcenter.getZ()));
        double radius = circumcenter.distance(new Vector(this.coordsOne.getX(), this.coordsOne.getY(), this.coordsOne.getZ()));
        int brushSize = NumberConversions.ceil((double)radius) + 1;
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    double tempDistance = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0), 0.5);
                    double cornerConstant = normalVector.getX() * (circumcenter.getX() + (double)x) + normalVector.getY() * (circumcenter.getY() + (double)y) + normalVector.getZ() * (circumcenter.getZ() + (double)z);
                    double centerConstant = normalVector.getX() * (circumcenter.getX() + (double)x + 0.5) + normalVector.getY() * (circumcenter.getY() + (double)y + 0.5) + normalVector.getZ() * (circumcenter.getZ() + (double)z + 0.5);
                    if (!(tempDistance <= radius) || !(Math.abs(cornerConstant - planeConstant) < (double)this.tolerance.getValue()) && !(Math.abs(centerConstant - planeConstant) < (double)this.tolerance.getValue())) continue;
                    this.current.perform(this.clampY(brushCenter.getBlockX() + x, brushCenter.getBlockY() + y, brushCenter.getBlockZ() + z));
                }
            }
        }
        v.sendMessage(ChatColor.GREEN + "Done.");
        v.owner().storeUndo(this.current.getUndo());
        this.coordsOne = null;
        this.coordsTwo = null;
        this.coordsThree = null;
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        switch (this.tolerance) {
            case ACCURATE: {
                vm.custom(ChatColor.GOLD + "Mode: Accurate");
                break;
            }
            case DEFAULT: {
                vm.custom(ChatColor.GOLD + "Mode: Default");
                break;
            }
            case SMOOTH: {
                vm.custom(ChatColor.GOLD + "Mode: Smooth");
                break;
            }
            default: {
                vm.custom(ChatColor.GOLD + "Mode: Unknown");
            }
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.YELLOW + "3-Point Circle Brush instructions: Select three corners with the arrow brush, then generate the Circle with the powder brush.");
            String toleranceOptions = "";
            for (Tolerance tolerance : Tolerance.values()) {
                if (!toleranceOptions.isEmpty()) {
                    toleranceOptions = toleranceOptions + "|";
                }
                toleranceOptions = toleranceOptions + tolerance.name().toLowerCase();
            }
            v.sendMessage(ChatColor.GOLD + "/b tpc " + toleranceOptions + " -- Toggle the calculations to emphasize accuracy or smoothness");
            return;
        }
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i].toUpperCase();
            try {
                this.tolerance = Tolerance.valueOf(parameter);
                v.sendMessage(ChatColor.AQUA + "Brush set to " + this.tolerance.name().toLowerCase() + " tolerance.");
                return;
            }
            catch (IllegalArgumentException exception) {
                v.getVoxelMessage().brushMessage("No such tolerance.");
                continue;
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.threepointcircle";
    }

    private static enum Tolerance {
        DEFAULT(1000),
        ACCURATE(10),
        SMOOTH(2000);

        private int value;

        private Tolerance(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

