/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class SplatterVoxelBrush
extends PerformBrush {
    private static final int GROW_PERCENT_MIN = 1;
    private static final int GROW_PERCENT_DEFAULT = 1000;
    private static final int GROW_PERCENT_MAX = 9999;
    private static final int SEED_PERCENT_MIN = 1;
    private static final int SEED_PERCENT_DEFAULT = 1000;
    private static final int SEED_PERCENT_MAX = 9999;
    private static final int SPLATREC_PERCENT_MIN = 1;
    private static final int SPLATREC_PERCENT_DEFAULT = 3;
    private static final int SPLATREC_PERCENT_MAX = 10;
    private int seedPercent;
    private int growPercent;
    private int splatterRecursions;
    private Random generator = new Random();

    public SplatterVoxelBrush() {
        this.setName("Splatter Voxel");
    }

    private void vSplatterBall(SnipeData v, Block targetBlock) {
        int z;
        int y;
        int x;
        if (this.seedPercent < 1 || this.seedPercent > 9999) {
            v.sendMessage(ChatColor.BLUE + "Seed percent set to: 10%");
            this.seedPercent = 1000;
        }
        if (this.growPercent < 1 || this.growPercent > 9999) {
            v.sendMessage(ChatColor.BLUE + "Growth percent set to: 10%");
            this.growPercent = 1000;
        }
        if (this.splatterRecursions < 1 || this.splatterRecursions > 10) {
            v.sendMessage(ChatColor.BLUE + "Recursions set to: 3");
            this.splatterRecursions = 3;
        }
        int[][][] splat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int x2 = 2 * v.getBrushSize(); x2 >= 0; --x2) {
            for (int y2 = 2 * v.getBrushSize(); y2 >= 0; --y2) {
                for (int z2 = 2 * v.getBrushSize(); z2 >= 0; --z2) {
                    if (this.generator.nextInt(10000) > this.seedPercent) continue;
                    splat[x2][y2][z2] = 1;
                }
            }
        }
        int gref = this.growPercent;
        int[][][] tempSplat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int z3;
            int y3;
            int x3;
            this.growPercent = gref - gref / this.splatterRecursions * r;
            for (x3 = 2 * v.getBrushSize(); x3 >= 0; --x3) {
                for (y3 = 2 * v.getBrushSize(); y3 >= 0; --y3) {
                    for (z3 = 2 * v.getBrushSize(); z3 >= 0; --z3) {
                        tempSplat[x3][y3][z3] = splat[x3][y3][z3];
                        int growcheck = 0;
                        if (splat[x3][y3][z3] == 0) {
                            if (x3 != 0 && splat[x3 - 1][y3][z3] == 1) {
                                ++growcheck;
                            }
                            if (y3 != 0 && splat[x3][y3 - 1][z3] == 1) {
                                ++growcheck;
                            }
                            if (z3 != 0 && splat[x3][y3][z3 - 1] == 1) {
                                ++growcheck;
                            }
                            if (x3 != 2 * v.getBrushSize() && splat[x3 + 1][y3][z3] == 1) {
                                ++growcheck;
                            }
                            if (y3 != 2 * v.getBrushSize() && splat[x3][y3 + 1][z3] == 1) {
                                ++growcheck;
                            }
                            if (z3 != 2 * v.getBrushSize() && splat[x3][y3][z3 + 1] == 1) {
                                ++growcheck;
                            }
                        }
                        if (growcheck < true || this.generator.nextInt(10000) > this.growPercent) continue;
                        tempSplat[x3][y3][z3] = 1;
                    }
                }
            }
            for (x3 = 2 * v.getBrushSize(); x3 >= 0; --x3) {
                for (y3 = 2 * v.getBrushSize(); y3 >= 0; --y3) {
                    for (z3 = 2 * v.getBrushSize(); z3 >= 0; --z3) {
                        splat[x3][y3][z3] = tempSplat[x3][y3][z3];
                    }
                }
            }
        }
        this.growPercent = gref;
        for (x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                for (z = 2 * v.getBrushSize(); z >= 0; --z) {
                    if (splat[Math.max(x - 1, 0)][y][z] != 1 || splat[Math.min(x + 1, 2 * v.getBrushSize())][y][z] != 1 || splat[x][Math.max(0, y - 1)][z] != 1 || splat[x][Math.min(2 * v.getBrushSize(), y + 1)][z] != 1) continue;
                    splat[x][y][z] = 1;
                }
            }
        }
        for (x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                for (z = 2 * v.getBrushSize(); z >= 0; --z) {
                    if (splat[x][y][z] != 1) continue;
                    this.current.perform(targetBlock.getRelative(-v.getBrushSize() + x, -v.getBrushSize() + z, -v.getBrushSize() + y));
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.vSplatterBall(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.vSplatterBall(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        if (this.seedPercent < 1 || this.seedPercent > 9999) {
            this.seedPercent = 1000;
        }
        if (this.growPercent < 1 || this.growPercent > 9999) {
            this.growPercent = 1000;
        }
        if (this.splatterRecursions < 1 || this.splatterRecursions > 10) {
            this.splatterRecursions = 3;
        }
        vm.brushName("Splatter Voxel");
        vm.size();
        vm.custom(ChatColor.BLUE + "Seed percent set to: " + this.seedPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Growth percent set to: " + this.growPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Recursions set to: " + this.splatterRecursions);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            double temp;
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Splatter Voxel brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b sv s[int] -- set a seed percentage (1-9999). 100 = 1% Default is 1000");
                v.sendMessage(ChatColor.AQUA + "/b sv g[int] -- set a growth percentage (1-9999).  Default is 1000");
                v.sendMessage(ChatColor.AQUA + "/b sv r[int] -- set a recursion (1-10).  Default is 3");
                return;
            }
            if (parameter.startsWith("s")) {
                temp = Integer.parseInt(parameter.replace("s", ""));
                if (temp >= 1.0 && temp <= 9999.0) {
                    v.sendMessage(ChatColor.AQUA + "Seed percent set to: " + temp / 100.0 + "%");
                    this.seedPercent = (int)temp;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Seed percent must be an integer 1-9999!");
                continue;
            }
            if (parameter.startsWith("g")) {
                temp = Integer.parseInt(parameter.replace("g", ""));
                if (temp >= 1.0 && temp <= 9999.0) {
                    v.sendMessage(ChatColor.AQUA + "Growth percent set to: " + temp / 100.0 + "%");
                    this.growPercent = (int)temp;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Growth percent must be an integer 1-9999!");
                continue;
            }
            if (parameter.startsWith("r")) {
                int temp2 = Integer.parseInt(parameter.replace("r", ""));
                if (temp2 >= 1 && temp2 <= 10) {
                    v.sendMessage(ChatColor.AQUA + "Recursions set to: " + temp2);
                    this.splatterRecursions = temp2;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Recursions must be an integer 1-10!");
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splattervoxel";
    }
}

