/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class SplatterDiscBrush
extends PerformBrush {
    private static final int GROW_PERCENT_MIN = 1;
    private static final int GROW_PERCENT_DEFAULT = 1000;
    private static final int GROW_PERCENT_MAX = 9999;
    private static final int SEED_PERCENT_MIN = 1;
    private static final int SEED_PERCENT_DEFAULT = 1000;
    private static final int SEED_PERCENT_MAX = 9999;
    private static final int SPLATREC_PERCENT_MIN = 1;
    private static final int SPLATREC_PERCENT_DEFAULT = 3;
    private static final int SPLATREC_PERCENT_MAX = 10;
    private int seedPercent;
    private int growPercent;
    private int splatterRecursions;
    private Random generator = new Random();

    public SplatterDiscBrush() {
        this.setName("Splatter Disc");
    }

    private void splatterDisc(SnipeData v, Block targetBlock) {
        if (this.seedPercent < 1 || this.seedPercent > 9999) {
            v.sendMessage(ChatColor.BLUE + "Seed percent set to: 10%");
            this.seedPercent = 1000;
        }
        if (this.growPercent < 1 || this.growPercent > 9999) {
            v.sendMessage(ChatColor.BLUE + "Growth percent set to: 10%");
            this.growPercent = 1000;
        }
        if (this.splatterRecursions < 1 || this.splatterRecursions > 10) {
            v.sendMessage(ChatColor.BLUE + "Recursions set to: 3");
            this.splatterRecursions = 3;
        }
        int[][] splat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int y = 2 * v.getBrushSize(); y >= 0; --y) {
                if (this.generator.nextInt(10000) > this.seedPercent) continue;
                splat[x][y] = 1;
            }
        }
        int gref = this.growPercent;
        int[][] tempSplat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int y;
            int x;
            this.growPercent = gref - gref / this.splatterRecursions * r;
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    tempSplat[x][y] = splat[x][y];
                    int growcheck = 0;
                    if (splat[x][y] == 0) {
                        if (x != 0 && splat[x - 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 0 && splat[x][y - 1] == 1) {
                            ++growcheck;
                        }
                        if (x != 2 * v.getBrushSize() && splat[x + 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 2 * v.getBrushSize() && splat[x][y + 1] == 1) {
                            ++growcheck;
                        }
                    }
                    if (growcheck < true || this.generator.nextInt(10000) > this.growPercent) continue;
                    tempSplat[x][y] = 1;
                }
            }
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    splat[x][y] = tempSplat[x][y];
                }
            }
        }
        this.growPercent = gref;
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int y = 2 * v.getBrushSize(); y >= 0; --y) {
                if (splat[Math.max(x - 1, 0)][y] != 1 || splat[Math.min(x + 1, 2 * v.getBrushSize())][y] != 1 || splat[x][Math.max(0, y - 1)] != 1 || splat[x][Math.min(2 * v.getBrushSize(), y + 1)] != 1) continue;
                splat[x][y] = 1;
            }
        }
        double rSquared = Math.pow(v.getBrushSize() + 1, 2.0);
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            double xSquared = Math.pow(x - v.getBrushSize() - 1, 2.0);
            for (int y = 2 * v.getBrushSize(); y >= 0; --y) {
                if (splat[x][y] != 1 || !(xSquared + Math.pow(y - v.getBrushSize() - 1, 2.0) <= rSquared)) continue;
                this.current.perform(targetBlock.getRelative(x - v.getBrushSize(), 0, y - v.getBrushSize()));
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.splatterDisc(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.splatterDisc(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        if (this.seedPercent < 1 || this.seedPercent > 9999) {
            this.seedPercent = 1000;
        }
        if (this.growPercent < 1 || this.growPercent > 9999) {
            this.growPercent = 1000;
        }
        if (this.splatterRecursions < 1 || this.splatterRecursions > 10) {
            this.splatterRecursions = 3;
        }
        vm.brushName("Splatter Disc");
        vm.size();
        vm.custom(ChatColor.BLUE + "Seed percent set to: " + this.seedPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Growth percent set to: " + this.growPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Recursions set to: " + this.splatterRecursions);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            double temp;
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Splatter Disc brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b sd s[int] -- set a seed percentage (1-9999). 100 = 1% Default is 1000");
                v.sendMessage(ChatColor.AQUA + "/b sd g[int] -- set a growth percentage (1-9999).  Default is 1000");
                v.sendMessage(ChatColor.AQUA + "/b sd r[int] -- set a recursion (1-10).  Default is 3");
                return;
            }
            if (parameter.startsWith("s")) {
                temp = Integer.parseInt(parameter.replace("s", ""));
                if (temp >= 1.0 && temp <= 9999.0) {
                    v.sendMessage(ChatColor.AQUA + "Seed percent set to: " + temp / 100.0 + "%");
                    this.seedPercent = (int)temp;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Seed percent must be an integer 1-9999!");
                continue;
            }
            if (parameter.startsWith("g")) {
                temp = Integer.parseInt(parameter.replace("g", ""));
                if (temp >= 1.0 && temp <= 9999.0) {
                    v.sendMessage(ChatColor.AQUA + "Growth percent set to: " + temp / 100.0 + "%");
                    this.growPercent = (int)temp;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Growth percent must be an integer 1-9999!");
                continue;
            }
            if (parameter.startsWith("r")) {
                int temp2 = Integer.parseInt(parameter.replace("r", ""));
                if (temp2 >= 1 && temp2 <= 10) {
                    v.sendMessage(ChatColor.AQUA + "Recursions set to: " + temp2);
                    this.splatterRecursions = temp2;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Recursions must be an integer 1-10!");
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splatterdisc";
    }
}

