/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class SpiralStaircaseBrush
extends Brush {
    private String stairtype = "block";
    private String sdirect = "c";
    private String sopen = "n";

    public SpiralStaircaseBrush() {
        this.setName("Spiral Staircase");
    }

    private void buildStairWell(SnipeData v, Block targetBlock) {
        if (v.getVoxelHeight() < 1) {
            v.setVoxelHeight(1);
            v.sendMessage(ChatColor.RED + "VoxelHeight must be a natural number! Set to 1.");
        }
        int[][][] spiral = new int[2 * v.getBrushSize() + 1][v.getVoxelHeight()][2 * v.getBrushSize() + 1];
        int startX = 0;
        int startZ = 0;
        int y = 0;
        int xOffset = 0;
        int zOffset = 0;
        int toggle = 0;
        if (this.sdirect.equalsIgnoreCase("cc")) {
            if (this.sopen.equalsIgnoreCase("n")) {
                startX = 0;
                startZ = 2 * v.getBrushSize();
            } else if (this.sopen.equalsIgnoreCase("e")) {
                startX = 0;
                startZ = 0;
            } else if (this.sopen.equalsIgnoreCase("s")) {
                startX = 2 * v.getBrushSize();
                startZ = 0;
            } else {
                startX = 2 * v.getBrushSize();
                startZ = 2 * v.getBrushSize();
            }
        } else if (this.sopen.equalsIgnoreCase("n")) {
            startX = 0;
            startZ = 0;
        } else if (this.sopen.equalsIgnoreCase("e")) {
            startX = 2 * v.getBrushSize();
            startZ = 0;
        } else if (this.sopen.equalsIgnoreCase("s")) {
            startX = 2 * v.getBrushSize();
            startZ = 2 * v.getBrushSize();
        } else {
            startX = 0;
            startZ = 2 * v.getBrushSize();
        }
        while (y < v.getVoxelHeight()) {
            if (this.stairtype.equalsIgnoreCase("block")) {
                spiral[startX + xOffset][y][startZ + zOffset] = 1;
                ++y;
            } else if (this.stairtype.equalsIgnoreCase("step")) {
                switch (toggle) {
                    case 0: {
                        toggle = 2;
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                        break;
                    }
                    case 1: {
                        toggle = 2;
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                        break;
                    }
                    case 2: {
                        toggle = 1;
                        spiral[startX + xOffset][y][startZ + zOffset] = 2;
                        ++y;
                        break;
                    }
                }
            }
            if (startX + xOffset == 0) {
                if (startZ + zOffset == 0) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        ++xOffset;
                        continue;
                    }
                    ++zOffset;
                    continue;
                }
                if (startZ + zOffset == 2 * v.getBrushSize()) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        --zOffset;
                        continue;
                    }
                    ++xOffset;
                    continue;
                }
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 5;
                        ++y;
                    }
                    --zOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 4;
                    ++y;
                }
                ++zOffset;
                continue;
            }
            if (startX + xOffset == 2 * v.getBrushSize()) {
                if (startZ + zOffset == 0) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        ++zOffset;
                        continue;
                    }
                    --xOffset;
                    continue;
                }
                if (startZ + zOffset == 2 * v.getBrushSize()) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        --xOffset;
                        continue;
                    }
                    --zOffset;
                    continue;
                }
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 4;
                        ++y;
                    }
                    ++zOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 5;
                    ++y;
                }
                --zOffset;
                continue;
            }
            if (startZ + zOffset == 0) {
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 2;
                        ++y;
                    }
                    ++xOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 3;
                    ++y;
                }
                --xOffset;
                continue;
            }
            if (this.sdirect.equalsIgnoreCase("c")) {
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 3;
                    ++y;
                }
                --xOffset;
                continue;
            }
            if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                spiral[startX + xOffset][y][startZ + zOffset] = 2;
                ++y;
            }
            ++xOffset;
        }
        Undo undo = new Undo();
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int i = v.getVoxelHeight() - 1; i >= 0; --i) {
                block13: for (int z = 2 * v.getBrushSize(); z >= 0; --z) {
                    int blockPositionX = targetBlock.getX();
                    int blockPositionY = targetBlock.getY();
                    int blockPositionZ = targetBlock.getZ();
                    switch (spiral[x][i][z]) {
                        case 0: {
                            if (i != v.getVoxelHeight() - 1) {
                                if ((this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) && spiral[x][i + 1][z] == 1) continue block13;
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 0) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 0);
                                continue block13;
                            }
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 0) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 0);
                            continue block13;
                        }
                        case 1: {
                            if (this.stairtype.equalsIgnoreCase("block")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != v.getVoxelId()) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, v.getVoxelId());
                                continue block13;
                            }
                            if (this.stairtype.equalsIgnoreCase("step")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 44) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 44);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData(v.getData());
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("woodstair") && !this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i - 1, blockPositionZ - v.getBrushSize() + z) != v.getVoxelId()) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i - 1, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i - 1, v.getVoxelId());
                            continue block13;
                        }
                        case 2: {
                            if (this.stairtype.equalsIgnoreCase("step")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 43) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 43);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData(v.getData());
                                continue block13;
                            }
                            if (this.stairtype.equalsIgnoreCase("woodstair")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 53) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 53);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData((byte)0);
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 67) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 67);
                            this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData((byte)0);
                            continue block13;
                        }
                        default: {
                            if (this.stairtype.equalsIgnoreCase("woodstair")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 53) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 53);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData((byte)(spiral[x][i][z] - 2));
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z) != 67) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY + i, 67);
                            this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z).setData((byte)(spiral[x][i][z] - 2));
                        }
                    }
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    private void digStairWell(SnipeData v, Block targetBlock) {
        if (v.getVoxelHeight() < 1) {
            v.setVoxelHeight(1);
            v.sendMessage(ChatColor.RED + "VoxelHeight must be a natural number! Set to 1.");
        }
        int[][][] spiral = new int[2 * v.getBrushSize() + 1][v.getVoxelHeight()][2 * v.getBrushSize() + 1];
        int startX = 0;
        int startZ = 0;
        int y = 0;
        int xOffset = 0;
        int zOffset = 0;
        int toggle = 0;
        if (this.sdirect.equalsIgnoreCase("cc")) {
            if (this.sopen.equalsIgnoreCase("n")) {
                startX = 0;
                startZ = 2 * v.getBrushSize();
            } else if (this.sopen.equalsIgnoreCase("e")) {
                startX = 0;
                startZ = 0;
            } else if (this.sopen.equalsIgnoreCase("s")) {
                startX = 2 * v.getBrushSize();
                startZ = 0;
            } else {
                startX = 2 * v.getBrushSize();
                startZ = 2 * v.getBrushSize();
            }
        } else if (this.sopen.equalsIgnoreCase("n")) {
            startX = 0;
            startZ = 0;
        } else if (this.sopen.equalsIgnoreCase("e")) {
            startX = 2 * v.getBrushSize();
            startZ = 0;
        } else if (this.sopen.equalsIgnoreCase("s")) {
            startX = 2 * v.getBrushSize();
            startZ = 2 * v.getBrushSize();
        } else {
            startX = 0;
            startZ = 2 * v.getBrushSize();
        }
        while (y < v.getVoxelHeight()) {
            if (this.stairtype.equalsIgnoreCase("block")) {
                spiral[startX + xOffset][y][startZ + zOffset] = 1;
                ++y;
            } else if (this.stairtype.equalsIgnoreCase("step")) {
                switch (toggle) {
                    case 0: {
                        toggle = 2;
                        spiral[startX + xOffset][y][startZ + zOffset] = 2;
                        break;
                    }
                    case 1: {
                        toggle = 2;
                        spiral[startX + xOffset][y][startZ + zOffset] = 2;
                        break;
                    }
                    case 2: {
                        toggle = 1;
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                        ++y;
                        break;
                    }
                }
            }
            if (startX + xOffset == 0) {
                if (startZ + zOffset == 0) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        ++xOffset;
                        continue;
                    }
                    ++zOffset;
                    continue;
                }
                if (startZ + zOffset == 2 * v.getBrushSize()) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        --zOffset;
                        continue;
                    }
                    ++xOffset;
                    continue;
                }
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 4;
                        ++y;
                    }
                    --zOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 5;
                    ++y;
                }
                ++zOffset;
                continue;
            }
            if (startX + xOffset == 2 * v.getBrushSize()) {
                if (startZ + zOffset == 0) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        ++zOffset;
                        continue;
                    }
                    --xOffset;
                    continue;
                }
                if (startZ + zOffset == 2 * v.getBrushSize()) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 1;
                    }
                    if (this.sdirect.equalsIgnoreCase("c")) {
                        --xOffset;
                        continue;
                    }
                    --zOffset;
                    continue;
                }
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 5;
                        ++y;
                    }
                    ++zOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 4;
                    ++y;
                }
                --zOffset;
                continue;
            }
            if (startZ + zOffset == 0) {
                if (this.sdirect.equalsIgnoreCase("c")) {
                    if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                        spiral[startX + xOffset][y][startZ + zOffset] = 3;
                        ++y;
                    }
                    ++xOffset;
                    continue;
                }
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 2;
                    ++y;
                }
                --xOffset;
                continue;
            }
            if (this.sdirect.equalsIgnoreCase("c")) {
                if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                    spiral[startX + xOffset][y][startZ + zOffset] = 2;
                    ++y;
                }
                --xOffset;
                continue;
            }
            if (this.stairtype.equalsIgnoreCase("woodstair") || this.stairtype.equalsIgnoreCase("cobblestair")) {
                spiral[startX + xOffset][y][startZ + zOffset] = 3;
                ++y;
            }
            ++xOffset;
        }
        Undo undo = new Undo();
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int i = v.getVoxelHeight() - 1; i >= 0; --i) {
                block13: for (int z = 2 * v.getBrushSize(); z >= 0; --z) {
                    int blockPositionX = targetBlock.getX();
                    int blockPositionY = targetBlock.getY();
                    int blockPositionZ = targetBlock.getZ();
                    switch (spiral[x][i][z]) {
                        case 0: {
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 0) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 0);
                            continue block13;
                        }
                        case 1: {
                            if (this.stairtype.equalsIgnoreCase("block")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != v.getVoxelId()) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, v.getVoxelId());
                                continue block13;
                            }
                            if (this.stairtype.equalsIgnoreCase("step")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 44) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 44);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData(v.getData());
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("woodstair") && !this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != v.getVoxelId()) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, v.getVoxelId());
                            continue block13;
                        }
                        case 2: {
                            if (this.stairtype.equalsIgnoreCase("step")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 43) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 43);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData(v.getData());
                                continue block13;
                            }
                            if (this.stairtype.equalsIgnoreCase("woodstair")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 53) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() - x, blockPositionY + i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 53);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData((byte)0);
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 67) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 67);
                            this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData((byte)0);
                            continue block13;
                        }
                        default: {
                            if (this.stairtype.equalsIgnoreCase("woodstair")) {
                                if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 53) {
                                    undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                                }
                                this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 53);
                                this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData((byte)(spiral[x][i][z] - 2));
                                continue block13;
                            }
                            if (!this.stairtype.equalsIgnoreCase("cobblestair")) continue block13;
                            if (this.getBlockIdAt(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z) != 67) {
                                undo.put(this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z));
                            }
                            this.setBlockIdAt(blockPositionZ - v.getBrushSize() + z, blockPositionX - v.getBrushSize() + x, blockPositionY - i, 67);
                            this.clampY(blockPositionX - v.getBrushSize() + x, blockPositionY - i, blockPositionZ - v.getBrushSize() + z).setData((byte)(spiral[x][i][z] - 2));
                        }
                    }
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.digStairWell(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.buildStairWell(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Spiral Staircase");
        vm.size();
        vm.voxel();
        vm.height();
        vm.data();
        vm.custom(ChatColor.BLUE + "Staircase type: " + this.stairtype);
        vm.custom(ChatColor.BLUE + "Staircase turns: " + this.sdirect);
        vm.custom(ChatColor.BLUE + "Staircase opens: " + this.sopen);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Spiral Staircase Parameters:");
            v.sendMessage(ChatColor.AQUA + "/b sstair 'block' (default) | 'step' | 'woodstair' | 'cobblestair' -- set the type of staircase");
            v.sendMessage(ChatColor.AQUA + "/b sstair 'c' (default) | 'cc' -- set the turning direction of staircase");
            v.sendMessage(ChatColor.AQUA + "/b sstair 'n' (default) | 'e' | 's' | 'world' -- set the opening direction of staircase");
            return;
        }
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("block") || par[i].equalsIgnoreCase("step") || par[i].equalsIgnoreCase("woodstair") || par[i].equalsIgnoreCase("cobblestair")) {
                this.stairtype = par[i];
                v.sendMessage(ChatColor.BLUE + "Staircase type: " + this.stairtype);
                continue;
            }
            if (par[i].equalsIgnoreCase("c") || par[i].equalsIgnoreCase("cc")) {
                this.sdirect = par[i];
                v.sendMessage(ChatColor.BLUE + "Staircase turns: " + this.sdirect);
                continue;
            }
            if (par[i].equalsIgnoreCase("n") || par[i].equalsIgnoreCase("e") || par[i].equalsIgnoreCase("s") || par[i].equalsIgnoreCase("world")) {
                this.sopen = par[i];
                v.sendMessage(ChatColor.BLUE + "Staircase opens: " + this.sopen);
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.spiralstaircase";
    }
}

