/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class ShellVoxelBrush
extends Brush {
    public ShellVoxelBrush() {
        this.setName("Shell Voxel");
    }

    private void vShell(SnipeData v, Block targetBlock) {
        int y;
        int z;
        int y2;
        int x;
        int brushSize = v.getBrushSize();
        int brushSizeSquared = 2 * brushSize;
        int[][][] oldMaterials = new int[2 * (brushSize + 1) + 1][2 * (brushSize + 1) + 1][2 * (brushSize + 1) + 1];
        int[][][] newMaterials = new int[2 * brushSize + 1][2 * brushSize + 1][2 * brushSize + 1];
        int blockPositionX = targetBlock.getX();
        int blockPositionY = targetBlock.getY();
        int blockPositionZ = targetBlock.getZ();
        for (x = 0; x <= 2 * (brushSize + 1); ++x) {
            for (y2 = 0; y2 <= 2 * (brushSize + 1); ++y2) {
                for (z = 0; z <= 2 * (brushSize + 1); ++z) {
                    oldMaterials[x][y2][z] = this.getBlockIdAt(blockPositionX - brushSize - 1 + x, blockPositionY - brushSize - 1 + y2, blockPositionZ - brushSize - 1 + z);
                }
            }
        }
        for (x = 0; x <= brushSizeSquared; ++x) {
            for (y2 = 0; y2 <= brushSizeSquared; ++y2) {
                for (z = 0; z <= brushSizeSquared; ++z) {
                    newMaterials[x][y2][z] = oldMaterials[x + 1][y2 + 1][z + 1];
                }
            }
        }
        for (int x2 = 0; x2 <= brushSizeSquared; ++x2) {
            for (z = 0; z <= brushSizeSquared; ++z) {
                for (y = 0; y <= brushSizeSquared; ++y) {
                    int temp = 0;
                    if (oldMaterials[x2 + 1 + 1][z + 1][y + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1 - 1][z + 1][y + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][z + 1 + 1][y + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][z + 1 - 1][y + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][z + 1][y + 1 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][z + 1][y + 1 - 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (temp != 0) continue;
                    newMaterials[x2][z][y] = v.getVoxelId();
                }
            }
        }
        Undo undo = new Undo();
        for (int x3 = brushSizeSquared; x3 >= 0; --x3) {
            for (y = 0; y <= brushSizeSquared; ++y) {
                for (int z2 = brushSizeSquared; z2 >= 0; --z2) {
                    if (this.getBlockIdAt(blockPositionX - brushSize + x3, blockPositionY - brushSize + y, blockPositionZ - brushSize + z2) != newMaterials[x3][y][z2]) {
                        undo.put(this.clampY(blockPositionX - brushSize + x3, blockPositionY - brushSize + y, blockPositionZ - brushSize + z2));
                    }
                    this.setBlockIdAt(blockPositionZ - brushSize + z2, blockPositionX - brushSize + x3, blockPositionY - brushSize + y, newMaterials[x3][y][z2]);
                }
            }
        }
        v.owner().storeUndo(undo);
        v.owner().getPlayer().sendMessage(ChatColor.AQUA + "Shell complete.");
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.vShell(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.vShell(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.replace();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Shell Voxel Parameters:");
        } else {
            v.sendMessage(ChatColor.RED + "Invalid parameter - see the info message for help.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.shellvoxel";
    }
}

