/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class ShellBallBrush
extends Brush {
    public ShellBallBrush() {
        this.setName("Shell Ball");
    }

    private void bShell(SnipeData v, Block targetBlock) {
        int z;
        int y;
        int x;
        int brushSize = v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][][] oldMaterials = new int[2 * (brushSize + 1) + 1][2 * (brushSize + 1) + 1][2 * (brushSize + 1) + 1];
        int[][][] newMaterials = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        int blockPositionX = targetBlock.getX();
        int blockPositionY = targetBlock.getY();
        int blockPositionZ = targetBlock.getZ();
        for (x = 0; x <= 2 * (brushSize + 1); ++x) {
            for (y = 0; y <= 2 * (brushSize + 1); ++y) {
                for (z = 0; z <= 2 * (brushSize + 1); ++z) {
                    oldMaterials[x][y][z] = this.getBlockIdAt(blockPositionX - brushSize - 1 + x, blockPositionY - brushSize - 1 + y, blockPositionZ - brushSize - 1 + z);
                }
            }
        }
        for (x = 0; x <= brushSizeDoubled; ++x) {
            for (y = 0; y <= brushSizeDoubled; ++y) {
                for (z = 0; z <= brushSizeDoubled; ++z) {
                    newMaterials[x][y][z] = oldMaterials[x + 1][y + 1][z + 1];
                }
            }
        }
        for (int x2 = 0; x2 <= brushSizeDoubled; ++x2) {
            for (int y2 = 0; y2 <= brushSizeDoubled; ++y2) {
                for (int z2 = 0; z2 <= brushSizeDoubled; ++z2) {
                    int temp = 0;
                    if (oldMaterials[x2 + 1 + 1][y2 + 1][z2 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1 - 1][y2 + 1][z2 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][y2 + 1 + 1][z2 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][y2 + 1 - 1][z2 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][y2 + 1][z2 + 1 + 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (oldMaterials[x2 + 1][y2 + 1][z2 + 1 - 1] == v.getReplaceId()) {
                        ++temp;
                    }
                    if (temp != 0) continue;
                    newMaterials[x2][y2][z2] = v.getVoxelId();
                }
            }
        }
        Undo undo = new Undo();
        double rSquared = Math.pow((double)brushSize + 0.5, 2.0);
        for (int x3 = brushSizeDoubled; x3 >= 0; --x3) {
            double xSquared = Math.pow(x3 - brushSize, 2.0);
            for (int y3 = 0; y3 <= 2 * brushSize; ++y3) {
                double ySquared = Math.pow(y3 - brushSize, 2.0);
                for (int z3 = 2 * brushSize; z3 >= 0; --z3) {
                    if (!(xSquared + ySquared + Math.pow(z3 - brushSize, 2.0) <= rSquared)) continue;
                    if (this.getBlockIdAt(blockPositionX - brushSize + x3, blockPositionY - brushSize + y3, blockPositionZ - brushSize + z3) != newMaterials[x3][y3][z3]) {
                        undo.put(this.clampY(blockPositionX - brushSize + x3, blockPositionY - brushSize + y3, blockPositionZ - brushSize + z3));
                    }
                    this.setBlockIdAt(blockPositionZ - brushSize + z3, blockPositionX - brushSize + x3, blockPositionY - brushSize + y3, newMaterials[x3][y3][z3]);
                }
            }
        }
        v.owner().storeUndo(undo);
        v.owner().getPlayer().sendMessage(ChatColor.AQUA + "Shell complete.");
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bShell(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bShell(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.replace();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.shellball";
    }
}

