/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockWrapper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class Rot2DvertBrush
extends Brush {
    private int mode = 0;
    private int bSize;
    private int brushSize;
    private BlockWrapper[][][] snap;
    private double se;

    public Rot2DvertBrush() {
        this.setName("2D Rotation");
    }

    private void getMatrix() {
        this.brushSize = this.bSize * 2 + 1;
        this.snap = new BlockWrapper[this.brushSize][this.brushSize][this.brushSize];
        int sx = this.getTargetBlock().getX() - this.bSize;
        int sy = this.getTargetBlock().getY() - this.bSize;
        int sz = this.getTargetBlock().getZ() - this.bSize;
        for (int x = 0; x < this.snap.length; ++x) {
            sz = this.getTargetBlock().getZ() - this.bSize;
            for (int z = 0; z < this.snap.length; ++z) {
                sy = this.getTargetBlock().getY() - this.bSize;
                for (int y = 0; y < this.snap.length; ++y) {
                    Block block = this.clampY(sx, sy, sz);
                    this.snap[x][y][z] = new BlockWrapper(block);
                    block.setTypeId(0);
                    ++sy;
                }
                ++sz;
            }
            ++sx;
        }
    }

    private void rotate(SnipeData v) {
        int z;
        int x;
        double brushSizeSquared = Math.pow((double)this.bSize + 0.5, 2.0);
        double cos = Math.cos(this.se);
        double sin = Math.sin(this.se);
        boolean[][] doNotFill = new boolean[this.snap.length][this.snap.length];
        for (x = 0; x < this.snap.length; ++x) {
            int xx = x - this.bSize;
            double xSquared = Math.pow(xx, 2.0);
            for (z = 0; z < this.snap.length; ++z) {
                int zz = z - this.bSize;
                if (!(xSquared + Math.pow(zz, 2.0) <= brushSizeSquared)) continue;
                double newX = (double)xx * cos - (double)zz * sin;
                double newZ = (double)xx * sin + (double)zz * cos;
                doNotFill[(int)newX + this.bSize][(int)newZ + this.bSize] = true;
                for (int y = 0; y < this.snap.length; ++y) {
                    int yy = y - this.bSize;
                    BlockWrapper block = this.snap[y][x][z];
                    if (block.getId() == 0) continue;
                    this.setBlockIdAndDataAt(this.getTargetBlock().getX() + yy, this.getTargetBlock().getY() + (int)newX, this.getTargetBlock().getZ() + (int)newZ, block.getId(), block.getData());
                }
            }
        }
        for (x = 0; x < this.snap.length; ++x) {
            double xSquared = Math.pow(x - this.bSize, 2.0);
            int fx = x + this.getTargetBlock().getX() - this.bSize;
            for (z = 0; z < this.snap.length; ++z) {
                if (!(xSquared + Math.pow(z - this.bSize, 2.0) <= brushSizeSquared)) continue;
                int fz = z + this.getTargetBlock().getZ() - this.bSize;
                if (doNotFill[x][z]) continue;
                for (int y = 0; y < this.snap.length; ++y) {
                    byte winnerData;
                    int winner;
                    int fy = y + this.getTargetBlock().getY() - this.bSize;
                    int a = this.getBlockIdAt(fy, fx + 1, fz);
                    byte aData = this.getBlockDataAt(fy, fx + 1, fz);
                    int d = this.getBlockIdAt(fy, fx - 1, fz);
                    byte dData = this.getBlockDataAt(fy, fx - 1, fz);
                    int c = this.getBlockIdAt(fy, fx, fz + 1);
                    int b = this.getBlockIdAt(fy, fx, fz - 1);
                    byte bData = this.getBlockDataAt(fy, fx, fz - 1);
                    if (a == b || a == c || a == d) {
                        winner = a;
                        winnerData = aData;
                    } else if (b == d || c == d) {
                        winner = d;
                        winnerData = dData;
                    } else {
                        winner = b;
                        winnerData = bData;
                    }
                    this.setBlockIdAndDataAt(fy, fx, fz, winner, winnerData);
                }
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        try {
            this.se = Math.toRadians(Double.parseDouble(par[1]));
            v.sendMessage(ChatColor.GREEN + "Angle set to " + this.se);
        }
        catch (Exception _ex) {
            v.sendMessage("Exception while parsing parameter: " + par[1]);
            Bukkit.getLogger().severe(_ex.getMessage());
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.rot2dvert";
    }
}

