/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class LineBrush
extends PerformBrush {
    private static final Vector HALF_BLOCK_OFFSET = new Vector(0.5, 0.5, 0.5);
    private Vector originCoords = null;
    private Vector targetCoords = new Vector();
    private World targetWorld;

    public LineBrush() {
        this.setName("Line");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Line Brush instructions: Right click first point with the arrow. Right click with powder to draw a line to set the second point.");
        }
    }

    private void linePowder(SnipeData v) {
        Vector originClone = this.originCoords.clone().add(HALF_BLOCK_OFFSET);
        Vector targetClone = this.targetCoords.clone().add(HALF_BLOCK_OFFSET);
        Vector direction = targetClone.clone().subtract(originClone);
        double length = this.targetCoords.distance(this.originCoords);
        if (length == 0.0) {
            this.current.perform(this.targetCoords.toLocation(this.targetWorld).getBlock());
        } else {
            BlockIterator blockIterator = new BlockIterator(this.targetWorld, originClone, direction, 0.0, NumberConversions.round((double)length));
            while (blockIterator.hasNext()) {
                Block currentBlock = blockIterator.next();
                this.current.perform(currentBlock);
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.originCoords = this.getTargetBlock().getLocation().toVector();
        this.targetWorld = this.getTargetBlock().getWorld();
        v.owner().getPlayer().sendMessage(ChatColor.DARK_PURPLE + "First point selected.");
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.originCoords == null || !this.getTargetBlock().getWorld().equals(this.targetWorld)) {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "Warning: You did not select a first coordinate with the arrow");
        } else {
            this.targetCoords = this.getTargetBlock().getLocation().toVector();
            this.linePowder(v);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.line";
    }
}

