/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.jsap.HelpJSAP;
import com.thevoxelbox.voxelsniper.jsap.NullableIntegerStringParser;
import com.thevoxelbox.voxelsniper.libs.com.google.common.base.Objects;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.FlaggedOption;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.JSAPException;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.JSAPResult;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.UnflaggedOption;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.stringparsers.EnumeratedStringParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ErodeBrush
extends Brush {
    private static final Vector[] FACES_TO_CHECK = new Vector[]{new Vector(0, 0, 1), new Vector(0, 0, -1), new Vector(0, 1, 0), new Vector(0, -1, 0), new Vector(1, 0, 0), new Vector(-1, 0, 0)};
    private final HelpJSAP parser = new HelpJSAP("/b e", "Brush for eroding landscape.", 55);
    private ErosionPreset currentPreset = new ErosionPreset(0, 1, 0, 1);

    public ErodeBrush() {
        this.setName("Erode");
        try {
            this.parser.registerParameter(new UnflaggedOption("preset", EnumeratedStringParser.getParser(Preset.getValuesString(";"), false), null, false, false, "Preset options: " + Preset.getValuesString(", ")));
            this.parser.registerParameter(new FlaggedOption("fill", NullableIntegerStringParser.getParser(), null, false, 'f', "fill", "Surrounding blocks required to fill the block."));
            this.parser.registerParameter(new FlaggedOption("erode", NullableIntegerStringParser.getParser(), null, false, 'e', "erode", "Surrounding air required to erode the block."));
            this.parser.registerParameter(new FlaggedOption("fillrecursion", NullableIntegerStringParser.getParser(), null, false, 'F', "fillrecursion", "Repeated fill iterations."));
            this.parser.registerParameter(new FlaggedOption("eroderecursion", NullableIntegerStringParser.getParser(), null, false, 'E', "eroderecursion", "Repeated erode iterations."));
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public static boolean sendHelpOrErrorMessageToPlayer(JSAPResult result, Player player, HelpJSAP helpJSAP) {
        List<String> output = helpJSAP.writeHelpOrErrorMessageIfRequired(result);
        if (!output.isEmpty()) {
            for (String string : output) {
                player.sendMessage(string);
            }
            return true;
        }
        return false;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.erosion(v, this.currentPreset);
    }

    private void erosion(SnipeData v, ErosionPreset erosionPreset) {
        int i;
        BlockChangeTracker blockChangeTracker = new BlockChangeTracker(this.getTargetBlock().getWorld());
        Vector targetBlockVector = this.getTargetBlock().getLocation().toVector();
        for (i = 0; i < erosionPreset.getErosionRecursion(); ++i) {
            this.erosionIteration(v, erosionPreset, blockChangeTracker, targetBlockVector);
        }
        for (i = 0; i < erosionPreset.getFillRecursion(); ++i) {
            this.fillIteration(v, erosionPreset, blockChangeTracker, targetBlockVector);
        }
        Undo undo = new Undo();
        for (BlockWrapper blockWrapper : blockChangeTracker.getAll()) {
            undo.put(blockWrapper.getBlock());
            blockWrapper.getBlock().setTypeIdAndData(blockWrapper.getMaterial().getId(), blockWrapper.getData(), true);
        }
        v.owner().storeUndo(undo);
    }

    private void fillIteration(SnipeData v, ErosionPreset erosionPreset, BlockChangeTracker blockChangeTracker, Vector targetBlockVector) {
        int currentIteration = blockChangeTracker.nextIteration();
        for (int x = this.getTargetBlock().getX() - v.getBrushSize(); x <= this.getTargetBlock().getX() + v.getBrushSize(); ++x) {
            for (int z = this.getTargetBlock().getZ() - v.getBrushSize(); z <= this.getTargetBlock().getZ() + v.getBrushSize(); ++z) {
                for (int y = this.getTargetBlock().getY() - v.getBrushSize(); y <= this.getTargetBlock().getY() + v.getBrushSize(); ++y) {
                    BlockWrapper currentBlock;
                    Vector currentPosition = new Vector(x, y, z);
                    if (!currentPosition.isInSphere(targetBlockVector, (double)v.getBrushSize()) || !(currentBlock = blockChangeTracker.get(currentPosition, currentIteration)).isEmpty() && !currentBlock.isLiquid()) continue;
                    int count = 0;
                    HashMap<BlockWrapper, Integer> blockCount = new HashMap<BlockWrapper, Integer>();
                    for (Vector vector : FACES_TO_CHECK) {
                        Vector relativePosition = currentPosition.clone().add(vector);
                        BlockWrapper relativeBlock = blockChangeTracker.get(relativePosition, currentIteration);
                        if (relativeBlock.isEmpty() || relativeBlock.isLiquid()) continue;
                        ++count;
                        BlockWrapper typeBlock = new BlockWrapper(null, relativeBlock.getMaterial(), relativeBlock.getData());
                        if (blockCount.containsKey(typeBlock)) {
                            blockCount.put(typeBlock, (Integer)blockCount.get(typeBlock) + 1);
                            continue;
                        }
                        blockCount.put(typeBlock, 1);
                    }
                    BlockWrapper currentMaterial = new BlockWrapper(null, Material.AIR, 0);
                    int amount = 0;
                    for (BlockWrapper wrapper : blockCount.keySet()) {
                        Integer currentCount = (Integer)blockCount.get(wrapper);
                        if (amount > currentCount) continue;
                        currentMaterial = wrapper;
                        amount = currentCount;
                    }
                    if (count < erosionPreset.getFillFaces()) continue;
                    blockChangeTracker.put(currentPosition, new BlockWrapper(currentBlock.getBlock(), currentMaterial.getMaterial(), currentMaterial.getData()), currentIteration);
                }
            }
        }
    }

    private void erosionIteration(SnipeData v, ErosionPreset erosionPreset, BlockChangeTracker blockChangeTracker, Vector targetBlockVector) {
        int currentIteration = blockChangeTracker.nextIteration();
        for (int x = this.getTargetBlock().getX() - v.getBrushSize(); x <= this.getTargetBlock().getX() + v.getBrushSize(); ++x) {
            for (int z = this.getTargetBlock().getZ() - v.getBrushSize(); z <= this.getTargetBlock().getZ() + v.getBrushSize(); ++z) {
                for (int y = this.getTargetBlock().getY() - v.getBrushSize(); y <= this.getTargetBlock().getY() + v.getBrushSize(); ++y) {
                    BlockWrapper currentBlock;
                    Vector currentPosition = new Vector(x, y, z);
                    if (!currentPosition.isInSphere(targetBlockVector, (double)v.getBrushSize()) || (currentBlock = blockChangeTracker.get(currentPosition, currentIteration)).isEmpty() || currentBlock.isLiquid()) continue;
                    int count = 0;
                    for (Vector vector : FACES_TO_CHECK) {
                        Vector relativePosition = currentPosition.clone().add(vector);
                        BlockWrapper relativeBlock = blockChangeTracker.get(relativePosition, currentIteration);
                        if (!relativeBlock.isEmpty() && !relativeBlock.isLiquid()) continue;
                        ++count;
                    }
                    if (count < erosionPreset.getErosionFaces()) continue;
                    blockChangeTracker.put(currentPosition, new BlockWrapper(currentBlock.getBlock(), Material.AIR, 0), currentIteration);
                }
            }
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.erosion(v, this.currentPreset.getInverted());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.AQUA + "Erosion minimum exposed faces set to " + this.currentPreset.getErosionFaces());
        vm.custom(ChatColor.BLUE + "Fill minumum touching faces set to " + this.currentPreset.getFillFaces());
        vm.custom(ChatColor.DARK_BLUE + "Erosion recursion amount set to " + this.currentPreset.getErosionRecursion());
        vm.custom(ChatColor.DARK_GREEN + "Fill recursion amount set to " + this.currentPreset.getFillRecursion());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        JSAPResult result = this.parser.parse(Arrays.copyOfRange(par, 1, par.length));
        if (ErodeBrush.sendHelpOrErrorMessageToPlayer(result, v.owner().getPlayer(), this.parser)) {
            return;
        }
        if (result.getString("preset") != null) {
            try {
                this.currentPreset = Preset.valueOf(result.getString("preset").toUpperCase()).getPreset();
                v.getVoxelMessage().brushMessage("Brush preset set to " + result.getString("preset"));
                return;
            }
            catch (IllegalArgumentException exception) {
                v.getVoxelMessage().brushMessage("No such preset.");
                return;
            }
        }
        ErosionPreset currentPresetBackup = this.currentPreset;
        if (result.getObject("fill") != null) {
            this.currentPreset = new ErosionPreset(this.currentPreset.getErosionFaces(), this.currentPreset.getErosionRecursion(), result.getInt("fill"), this.currentPreset.getFillRecursion());
        }
        if (result.getObject("erode") != null) {
            this.currentPreset = new ErosionPreset(result.getInt("erode"), this.currentPreset.getErosionRecursion(), this.currentPreset.getFillFaces(), this.currentPreset.getFillRecursion());
        }
        if (result.getObject("fillrecursion") != null) {
            this.currentPreset = new ErosionPreset(this.currentPreset.getErosionFaces(), this.currentPreset.getErosionRecursion(), this.currentPreset.getFillFaces(), result.getInt("fillrecursion"));
        }
        if (result.getObject("eroderecursion") != null) {
            this.currentPreset = new ErosionPreset(this.currentPreset.getErosionFaces(), result.getInt("eroderecursion"), this.currentPreset.getFillFaces(), this.currentPreset.getFillRecursion());
        }
        if (!this.currentPreset.equals(currentPresetBackup)) {
            if (this.currentPreset.getErosionFaces() != currentPresetBackup.getErosionFaces()) {
                v.sendMessage(ChatColor.AQUA + "Erosion faces set to: " + ChatColor.WHITE + this.currentPreset.getErosionFaces());
            }
            if (this.currentPreset.getFillFaces() != currentPresetBackup.getFillFaces()) {
                v.sendMessage(ChatColor.AQUA + "Fill faces set to: " + ChatColor.WHITE + this.currentPreset.getFillFaces());
            }
            if (this.currentPreset.getErosionRecursion() != currentPresetBackup.getErosionRecursion()) {
                v.sendMessage(ChatColor.AQUA + "Erosion recursions set to: " + ChatColor.WHITE + this.currentPreset.getErosionRecursion());
            }
            if (this.currentPreset.getFillRecursion() != currentPresetBackup.getFillRecursion()) {
                v.sendMessage(ChatColor.AQUA + "Fill recursions set to: " + ChatColor.WHITE + this.currentPreset.getFillRecursion());
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.erode";
    }

    private static final class ErosionPreset {
        private final int erosionFaces;
        private final int erosionRecursion;
        private final int fillFaces;
        private final int fillRecursion;

        public ErosionPreset(int erosionFaces, int erosionRecursion, int fillFaces, int fillRecursion) {
            this.erosionFaces = erosionFaces;
            this.erosionRecursion = erosionRecursion;
            this.fillFaces = fillFaces;
            this.fillRecursion = fillRecursion;
        }

        public int hashCode() {
            return Objects.hashCode(this.erosionFaces, this.erosionRecursion, this.fillFaces, this.fillRecursion);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErosionPreset) {
                ErosionPreset other = (ErosionPreset)obj;
                return Objects.equal(this.erosionFaces, other.erosionFaces) && Objects.equal(this.erosionRecursion, other.erosionRecursion) && Objects.equal(this.fillFaces, other.fillFaces) && Objects.equal(this.fillRecursion, other.fillRecursion);
            }
            return false;
        }

        public int getErosionFaces() {
            return this.erosionFaces;
        }

        public int getErosionRecursion() {
            return this.erosionRecursion;
        }

        public int getFillFaces() {
            return this.fillFaces;
        }

        public int getFillRecursion() {
            return this.fillRecursion;
        }

        public ErosionPreset getInverted() {
            return new ErosionPreset(this.fillFaces, this.fillRecursion, this.erosionFaces, this.erosionRecursion);
        }
    }

    private static final class BlockWrapper {
        private final Block block;
        private final Material material;
        private final byte data;

        public BlockWrapper(Block block) {
            this.block = block;
            this.data = block.getData();
            this.material = block.getType();
        }

        public BlockWrapper(Block block, Material material, byte data) {
            this.block = block;
            this.material = material;
            this.data = data;
        }

        public Block getBlock() {
            return this.block;
        }

        public byte getData() {
            return this.data;
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isEmpty() {
            return this.material == Material.AIR;
        }

        public boolean isLiquid() {
            switch (this.material) {
                case WATER: 
                case STATIONARY_WATER: 
                case LAVA: 
                case STATIONARY_LAVA: {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BlockChangeTracker {
        private final Map<Integer, Map<Vector, BlockWrapper>> blockChanges = new HashMap<Integer, Map<Vector, BlockWrapper>>();
        private final Map<Vector, BlockWrapper> flatChanges = new HashMap<Vector, BlockWrapper>();
        private final World world;
        private int nextIterationId = 0;

        public BlockChangeTracker(World world) {
            this.world = world;
        }

        public BlockWrapper get(Vector position, int iteration) {
            BlockWrapper changedBlock = null;
            for (int i = iteration - 1; i >= 0; --i) {
                if (!this.blockChanges.containsKey(i) || !this.blockChanges.get(i).containsKey(position)) continue;
                changedBlock = this.blockChanges.get(i).get(position);
                return changedBlock;
            }
            changedBlock = new BlockWrapper(position.toLocation(this.world).getBlock());
            return changedBlock;
        }

        public Collection<BlockWrapper> getAll() {
            return this.flatChanges.values();
        }

        public int nextIteration() {
            return this.nextIterationId++;
        }

        public void put(Vector position, BlockWrapper changedBlock, int iteration) {
            if (!this.blockChanges.containsKey(iteration)) {
                this.blockChanges.put(iteration, new HashMap());
            }
            this.blockChanges.get(iteration).put(position, changedBlock);
            this.flatChanges.put(position, changedBlock);
        }
    }

    private static enum Preset {
        MELT(new ErosionPreset(2, 1, 5, 1)),
        FILL(new ErosionPreset(5, 1, 2, 1)),
        SMOOTH(new ErosionPreset(3, 1, 3, 1)),
        LIFT(new ErosionPreset(6, 0, 1, 1)),
        FLOATCLEAN(new ErosionPreset(6, 1, 6, 1));

        private ErosionPreset preset;

        private Preset(ErosionPreset preset) {
            this.preset = preset;
        }

        public static String getValuesString(String seperator) {
            String valuesString = "";
            boolean delimiterHelper = true;
            for (Preset preset : Preset.values()) {
                if (delimiterHelper) {
                    delimiterHelper = false;
                } else {
                    valuesString = valuesString + seperator;
                }
                valuesString = valuesString + preset.name();
            }
            return valuesString;
        }

        public ErosionPreset getPreset() {
            return this.preset;
        }
    }
}

