/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class EllipseBrush
extends PerformBrush {
    private static final double TWO_PI = Math.PI * 2;
    private static final int SCL_MIN = 1;
    private static final int SCL_MAX = 9999;
    private static final int SCL_DEFAULT = 10;
    private static final int STEPS_MIN = 1;
    private static final int STEPS_MAX = 2000;
    private static final int STEPS_DEFAULT = 200;
    private int xscl;
    private int yscl;
    private int steps;
    private double stepSize;
    private boolean fill;

    public EllipseBrush() {
        this.setName("Ellipse");
    }

    private void ellipse(SnipeData v, Block targetBlock) {
        try {
            for (double steps = 0.0; steps <= Math.PI * 2; steps += this.stepSize) {
                int x = (int)Math.round((double)this.xscl * Math.cos(steps));
                int y = (int)Math.round((double)this.yscl * Math.sin(steps));
                switch (this.getTargetBlock().getFace(this.getLastBlock())) {
                    case NORTH: 
                    case SOUTH: {
                        this.current.perform(targetBlock.getRelative(0, x, y));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        this.current.perform(targetBlock.getRelative(x, y, 0));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        this.current.perform(targetBlock.getRelative(x, 0, y));
                    }
                }
                if (!(steps >= Math.PI * 2)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "Invalid target.");
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private void ellipsefill(SnipeData v, Block targetBlock) {
        int ix = this.xscl;
        int iy = this.yscl;
        this.current.perform(targetBlock);
        try {
            if (ix >= iy) {
                for (iy = this.yscl; iy > 0; --iy) {
                    for (double steps = 0.0; steps <= Math.PI * 2; steps += this.stepSize) {
                        int x = (int)Math.round((double)ix * Math.cos(steps));
                        int y = (int)Math.round((double)iy * Math.sin(steps));
                        switch (this.getTargetBlock().getFace(this.getLastBlock())) {
                            case NORTH: 
                            case SOUTH: {
                                this.current.perform(targetBlock.getRelative(0, x, y));
                                break;
                            }
                            case EAST: 
                            case WEST: {
                                this.current.perform(targetBlock.getRelative(x, y, 0));
                                break;
                            }
                            case UP: 
                            case DOWN: {
                                this.current.perform(targetBlock.getRelative(x, 0, y));
                            }
                        }
                        if (steps >= Math.PI * 2) break;
                    }
                    --ix;
                }
            } else {
                for (ix = this.xscl; ix > 0; --ix) {
                    for (double steps = 0.0; steps <= Math.PI * 2; steps += this.stepSize) {
                        int x = (int)Math.round((double)ix * Math.cos(steps));
                        int y = (int)Math.round((double)iy * Math.sin(steps));
                        switch (this.getTargetBlock().getFace(this.getLastBlock())) {
                            case NORTH: 
                            case SOUTH: {
                                this.current.perform(targetBlock.getRelative(0, x, y));
                                break;
                            }
                            case EAST: 
                            case WEST: {
                                this.current.perform(targetBlock.getRelative(x, y, 0));
                                break;
                            }
                            case UP: 
                            case DOWN: {
                                this.current.perform(targetBlock.getRelative(x, 0, y));
                            }
                        }
                        if (steps >= Math.PI * 2) break;
                    }
                    --iy;
                }
            }
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "Invalid target.");
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private void execute(SnipeData v, Block targetBlock) {
        this.stepSize = Math.PI * 2 / (double)this.steps;
        if (this.fill) {
            this.ellipsefill(v, targetBlock);
        } else {
            this.ellipse(v, targetBlock);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.execute(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.execute(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        if (this.xscl < 1 || this.xscl > 9999) {
            this.xscl = 10;
        }
        if (this.yscl < 1 || this.yscl > 9999) {
            this.yscl = 10;
        }
        if (this.steps < 1 || this.steps > 2000) {
            this.steps = 200;
        }
        vm.brushName(this.getName());
        vm.custom(ChatColor.AQUA + "X-size set to: " + ChatColor.DARK_AQUA + this.xscl);
        vm.custom(ChatColor.AQUA + "Y-size set to: " + ChatColor.DARK_AQUA + this.yscl);
        vm.custom(ChatColor.AQUA + "Render step number set to: " + ChatColor.DARK_AQUA + this.steps);
        if (this.fill) {
            vm.custom(ChatColor.AQUA + "Fill mode is enabled");
        } else {
            vm.custom(ChatColor.AQUA + "Fill mode is disabled");
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            try {
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.GOLD + "Ellipse brush parameters");
                    v.sendMessage(ChatColor.AQUA + "x[n]: Set X size modifier to n");
                    v.sendMessage(ChatColor.AQUA + "y[n]: Set Y size modifier to n");
                    v.sendMessage(ChatColor.AQUA + "t[n]: Set the amount of time steps");
                    v.sendMessage(ChatColor.AQUA + "fill: Toggles fill mode");
                    return;
                }
                if (parameter.startsWith("x")) {
                    int tempXScale = Integer.parseInt(par[i].replace("x", ""));
                    if (tempXScale < 1 || tempXScale > 9999) {
                        v.sendMessage(ChatColor.AQUA + "Invalid X scale (" + 1 + "-" + 9999 + ")");
                        continue;
                    }
                    this.xscl = tempXScale;
                    v.sendMessage(ChatColor.AQUA + "X-scale modifier set to: " + this.xscl);
                    continue;
                }
                if (parameter.startsWith("y")) {
                    int tempYScale = Integer.parseInt(par[i].replace("y", ""));
                    if (tempYScale < 1 || tempYScale > 9999) {
                        v.sendMessage(ChatColor.AQUA + "Invalid Y scale (" + 1 + "-" + 9999 + ")");
                        continue;
                    }
                    this.yscl = tempYScale;
                    v.sendMessage(ChatColor.AQUA + "Y-scale modifier set to: " + this.yscl);
                    continue;
                }
                if (parameter.startsWith("t")) {
                    int tempSteps = Integer.parseInt(par[i].replace("t", ""));
                    if (tempSteps < 1 || tempSteps > 2000) {
                        v.sendMessage(ChatColor.AQUA + "Invalid step number (" + 1 + "-" + 2000 + ")");
                        continue;
                    }
                    this.steps = tempSteps;
                    v.sendMessage(ChatColor.AQUA + "Render step number set to: " + this.steps);
                    continue;
                }
                if (parameter.equalsIgnoreCase("fill")) {
                    if (this.fill) {
                        this.fill = false;
                        v.sendMessage(ChatColor.AQUA + "Fill mode is disabled");
                        continue;
                    }
                    this.fill = true;
                    v.sendMessage(ChatColor.AQUA + "Fill mode is enabled");
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! Use the \"info\" parameter to display parameter info.");
                continue;
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + "Incorrect parameter \"" + parameter + "\"; use the \"info\" parameter.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ellipse";
    }
}

