/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.StampBrush;
import org.bukkit.ChatColor;

public class CloneStampBrush
extends StampBrush {
    public CloneStampBrush() {
        this.setName("Clone");
    }

    private void clone(SnipeData v) {
        int brushSize = v.getBrushSize();
        this.clone.clear();
        this.fall.clear();
        this.drop.clear();
        this.solid.clear();
        this.sorted = false;
        int yStartingPoint = this.getTargetBlock().getY() + v.getcCen();
        int yEndPoint = this.getTargetBlock().getY() + v.getVoxelHeight() + v.getcCen();
        if (yStartingPoint < 0) {
            yStartingPoint = 0;
            v.sendMessage(ChatColor.DARK_PURPLE + "Warning: off-world start position.");
        } else if (yStartingPoint > this.getWorld().getMaxHeight() - 1) {
            yStartingPoint = this.getWorld().getMaxHeight() - 1;
            v.sendMessage(ChatColor.DARK_PURPLE + "Warning: off-world start position.");
        }
        if (yEndPoint < 0) {
            yEndPoint = 0;
            v.sendMessage(ChatColor.DARK_PURPLE + "Warning: off-world end position.");
        } else if (yEndPoint > this.getWorld().getMaxHeight() - 1) {
            yEndPoint = this.getWorld().getMaxHeight() - 1;
            v.sendMessage(ChatColor.DARK_PURPLE + "Warning: off-world end position.");
        }
        double bSquared = Math.pow(brushSize, 2.0);
        for (int z = yStartingPoint; z < yEndPoint; ++z) {
            this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX(), z, this.getTargetBlock().getZ()), 0, z - yStartingPoint, 0));
            for (int y = 1; y <= brushSize; ++y) {
                this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX(), z, this.getTargetBlock().getZ() + y), 0, z - yStartingPoint, y));
                this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX(), z, this.getTargetBlock().getZ() - y), 0, z - yStartingPoint, -y));
                this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() + y, z, this.getTargetBlock().getZ()), y, z - yStartingPoint, 0));
                this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() - y, z, this.getTargetBlock().getZ()), -y, z - yStartingPoint, 0));
            }
            for (int x = 1; x <= brushSize; ++x) {
                double xSquared = Math.pow(x, 2.0);
                for (int y = 1; y <= brushSize; ++y) {
                    if (!(xSquared + Math.pow(y, 2.0) <= bSquared)) continue;
                    this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() + x, z, this.getTargetBlock().getZ() + y), x, z - yStartingPoint, y));
                    this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() + x, z, this.getTargetBlock().getZ() - y), x, z - yStartingPoint, -y));
                    this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() - x, z, this.getTargetBlock().getZ() + y), -x, z - yStartingPoint, y));
                    this.clone.add(new StampBrush.BlockWrapper(this, this.clampY(this.getTargetBlock().getX() - x, z, this.getTargetBlock().getZ() - y), -x, z - yStartingPoint, -y));
                }
            }
        }
        v.sendMessage(ChatColor.GREEN + String.valueOf(this.clone.size()) + ChatColor.AQUA + " blocks copied sucessfully.");
    }

    @Override
    protected final void powder(SnipeData v) {
        this.clone(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.height();
        vm.center();
        switch (this.stamp) {
            case DEFAULT: {
                vm.brushMessage("Default Stamp");
                break;
            }
            case NO_AIR: {
                vm.brushMessage("No-Air Stamp");
                break;
            }
            case FILL: {
                vm.brushMessage("Fill Stamp");
                break;
            }
            default: {
                vm.custom(ChatColor.DARK_RED + "Error while stamping! Report");
            }
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        String parameter = par[1];
        if (parameter.equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Clone / Stamp Cylinder brush parameters");
            v.sendMessage(ChatColor.GREEN + "cs f -- Activates Fill mode");
            v.sendMessage(ChatColor.GREEN + "cs a -- Activates No-Air mode");
            v.sendMessage(ChatColor.GREEN + "cs d -- Activates Default mode");
        }
        if (parameter.equalsIgnoreCase("a")) {
            this.setStamp(StampBrush.StampType.NO_AIR);
            this.reSort();
            v.sendMessage(ChatColor.AQUA + "No-Air stamp brush");
        } else if (parameter.equalsIgnoreCase("f")) {
            this.setStamp(StampBrush.StampType.FILL);
            this.reSort();
            v.sendMessage(ChatColor.AQUA + "Fill stamp brush");
        } else if (parameter.equalsIgnoreCase("d")) {
            this.setStamp(StampBrush.StampType.DEFAULT);
            this.reSort();
            v.sendMessage(ChatColor.AQUA + "Default stamp brush");
        } else if (parameter.startsWith("c")) {
            v.setcCen(Integer.parseInt(parameter.replace("c", "")));
            v.sendMessage(ChatColor.BLUE + "Center set to " + v.getcCen());
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.clonestamp";
    }
}

