/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.CanyonBrush;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;

public class CanyonSelectionBrush
extends CanyonBrush {
    private boolean first = true;
    private int fx;
    private int fz;

    public CanyonSelectionBrush() {
        this.setName("Canyon Selection");
    }

    private void execute(SnipeData v) {
        Chunk chunk = this.getTargetBlock().getChunk();
        if (this.first) {
            this.fx = chunk.getX();
            this.fz = chunk.getZ();
            v.sendMessage(ChatColor.YELLOW + "First point selected!");
            this.first = !this.first;
        } else {
            v.sendMessage(ChatColor.YELLOW + "Second point selected!");
            this.selection(Math.min(this.fx, chunk.getX()), Math.min(this.fz, chunk.getZ()), Math.max(this.fx, chunk.getX()), Math.max(this.fz, chunk.getZ()), v);
            this.first = !this.first;
        }
    }

    private void selection(int lowX, int lowZ, int highX, int highZ, SnipeData v) {
        Undo undo = new Undo();
        for (int x = lowX; x <= highX; ++x) {
            for (int z = lowZ; z <= highZ; ++z) {
                this.canyon(this.getWorld().getChunkAt(x, z), undo);
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.execute(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.execute(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GREEN + "Shift Level set to " + this.getYLevel());
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.canyonselection";
    }
}

