/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class CanyonBrush
extends Brush {
    private static final int SHIFT_LEVEL_MIN = 10;
    private static final int SHIFT_LEVEL_MAX = 60;
    private int yLevel = 10;

    public CanyonBrush() {
        this.setName("Canyon");
    }

    protected final void canyon(Chunk chunk, Undo undo) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int currentYLevel = this.yLevel;
                for (int y = 63; y < this.getWorld().getMaxHeight(); ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    Block currentYLevelBlock = chunk.getBlock(x, currentYLevel, z);
                    undo.put(block);
                    undo.put(currentYLevelBlock);
                    currentYLevelBlock.setTypeId(block.getTypeId(), false);
                    block.setType(Material.AIR);
                    ++currentYLevel;
                }
                Block block = chunk.getBlock(x, 0, z);
                undo.put(block);
                block.setTypeId(Material.BEDROCK.getId());
                for (int y = 1; y < 10; ++y) {
                    Block currentBlock = chunk.getBlock(x, y, z);
                    undo.put(currentBlock);
                    currentBlock.setType(Material.STONE);
                }
            }
        }
    }

    @Override
    protected void arrow(SnipeData v) {
        Undo undo = new Undo();
        this.canyon(this.getTargetBlock().getChunk(), undo);
        v.owner().storeUndo(undo);
    }

    @Override
    protected void powder(SnipeData v) {
        Undo undo = new Undo();
        Chunk targetChunk = this.getTargetBlock().getChunk();
        for (int x = targetChunk.getX() - 1; x <= targetChunk.getX() + 1; ++x) {
            for (int z = targetChunk.getX() - 1; z <= targetChunk.getX() + 1; ++z) {
                this.canyon(this.getWorld().getChunkAt(x, z), undo);
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GREEN + "Shift Level set to " + this.yLevel);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GREEN + "y[number] to set the Level to which the land will be shifted down");
        }
        if (par[1].startsWith("y")) {
            int _i = Integer.parseInt(par[1].replace("y", ""));
            if (_i < 10) {
                _i = 10;
            } else if (_i > 60) {
                _i = 60;
            }
            this.yLevel = _i;
            v.sendMessage(ChatColor.GREEN + "Shift Level set to " + this.yLevel);
        }
    }

    protected final int getYLevel() {
        return this.yLevel;
    }

    protected final void setYLevel(int yLevel) {
        this.yLevel = yLevel;
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.canyon";
    }
}

