/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.RangeBlockHelper;
import com.thevoxelbox.voxelsniper.SnipeAction;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import com.thevoxelbox.voxelsniper.util.BlockWrapper;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public abstract class Brush
implements IBrush {
    protected static final int CHUNK_SIZE = 16;
    private Block targetBlock;
    private Block lastBlock;
    private String name = "Undefined";

    public final Block clampY(int x, int y, int z) {
        int clampedY = y;
        if (clampedY < 0) {
            clampedY = 0;
        } else if (clampedY > this.getWorld().getMaxHeight()) {
            clampedY = this.getWorld().getMaxHeight();
        }
        return this.getWorld().getBlockAt(x, clampedY, z);
    }

    private boolean preparePerform(SnipeData v, Block clickedBlock, BlockFace clickedFace) {
        if (this.getTarget(v, clickedBlock, clickedFace)) {
            if (this instanceof PerformBrush) {
                ((PerformBrush)this).initP(v);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean perform(SnipeAction action, SnipeData data, Block targetBlock, Block lastBlock) {
        this.setTargetBlock(targetBlock);
        this.setLastBlock(lastBlock);
        switch (action) {
            case ARROW: {
                this.arrow(data);
                return true;
            }
            case GUNPOWDER: {
                this.powder(data);
                return true;
            }
        }
        return false;
    }

    protected void arrow(SnipeData v) {
    }

    protected void powder(SnipeData v) {
    }

    @Override
    public abstract void info(Message var1);

    @Override
    public void parameters(String[] par, SnipeData v) {
        v.sendMessage(ChatColor.RED + "This brush does not accept additional parameters.");
    }

    protected final boolean getTarget(SnipeData v, Block clickedBlock, BlockFace clickedFace) {
        RangeBlockHelper rangeBlockHelper;
        if (clickedBlock != null) {
            this.setTargetBlock(clickedBlock);
            this.setLastBlock(clickedBlock.getRelative(clickedFace));
            if (this.getLastBlock() == null) {
                v.sendMessage(ChatColor.RED + "Snipe target block must be visible.");
                return false;
            }
            if (v.owner().getSnipeData(v.owner().getCurrentToolId()).isLightningEnabled()) {
                this.getWorld().strikeLightning(this.getTargetBlock().getLocation());
            }
            return true;
        }
        if (v.owner().getSnipeData(v.owner().getCurrentToolId()).isRanged()) {
            rangeBlockHelper = new RangeBlockHelper(v.owner().getPlayer(), v.owner().getPlayer().getWorld(), (double)v.owner().getSnipeData(v.owner().getCurrentToolId()).getRange());
            this.setTargetBlock(rangeBlockHelper.getRangeBlock());
        } else {
            rangeBlockHelper = new RangeBlockHelper(v.owner().getPlayer(), v.owner().getPlayer().getWorld());
            this.setTargetBlock(rangeBlockHelper.getTargetBlock());
        }
        if (this.getTargetBlock() != null) {
            this.setLastBlock(rangeBlockHelper.getLastBlock());
            if (this.getLastBlock() == null) {
                v.sendMessage(ChatColor.RED + "Snipe target block must be visible.");
                return false;
            }
            if (v.owner().getSnipeData(v.owner().getCurrentToolId()).isLightningEnabled()) {
                this.getWorld().strikeLightning(this.getTargetBlock().getLocation());
            }
            return true;
        }
        v.sendMessage(ChatColor.RED + "Snipe target block must be visible.");
        return false;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBrushCategory() {
        return "General";
    }

    protected final Block getTargetBlock() {
        return this.targetBlock;
    }

    protected final void setTargetBlock(Block targetBlock) {
        this.targetBlock = targetBlock;
    }

    protected final World getWorld() {
        return this.targetBlock.getWorld();
    }

    protected int getBlockIdAt(int x, int y, int z) {
        return this.getWorld().getBlockTypeIdAt(x, y, z);
    }

    protected byte getBlockDataAt(int x, int y, int z) {
        return this.getWorld().getBlockAt(x, y, z).getData();
    }

    protected final Block getLastBlock() {
        return this.lastBlock;
    }

    protected final void setLastBlock(Block lastBlock) {
        this.lastBlock = lastBlock;
    }

    @Deprecated
    protected final void setBlock(BlockWrapper blockWrapper) {
        this.getWorld().getBlockAt(blockWrapper.getX(), blockWrapper.getY(), blockWrapper.getZ()).setTypeId(blockWrapper.getId());
    }

    protected final void setBlockIdAt(int z, int x, int y, int id) {
        this.getWorld().getBlockAt(x, y, z).setTypeId(id);
    }

    protected final void setBlockIdAndDataAt(int x, int y, int z, int id, byte data) {
        this.getWorld().getBlockAt(x, y, z).setTypeIdAndData(id, data, true);
    }
}

