/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.libs.com.google.common.base.Preconditions;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class VoxelSniperConfiguration {
    public static final String CONFIG_IDENTIFIER_LITESNIPER_MAX_BRUSH_SIZE = "litesniper-max-brush-size";
    public static final String CONFIG_IDENTIFIER_UNDO_CACHE_SIZE = "undo-cache-size";
    public static final String CONFIG_IDENTIFIER_LITESNIPER_RESTRICTED_ITEMS = "litesniper-restricted-items";
    public static final String CONFIG_IDENTIFIER_MESSAGE_ON_LOGIN_ENABLED = "message-on-login-enabled";
    public static final int DEFAULT_LITESNIPER_MAX_BRUSH_SIZE = 5;
    public static final int DEFAULT_UNDO_CACHE_SIZE = 20;
    public static final boolean DEFAULT_MESSAGE_ON_LOGIN_ENABLED = true;
    private FileConfiguration configuration;

    public VoxelSniperConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getUndoCacheSize() {
        return this.configuration.getInt(CONFIG_IDENTIFIER_UNDO_CACHE_SIZE, 20);
    }

    public void setUndoCacheSize(int size) {
        this.configuration.set(CONFIG_IDENTIFIER_UNDO_CACHE_SIZE, (Object)size);
    }

    public int getLiteSniperMaxBrushSize() {
        return this.configuration.getInt(CONFIG_IDENTIFIER_LITESNIPER_MAX_BRUSH_SIZE, 5);
    }

    public void setLiteSniperMaxBrushSize(int size) {
        this.configuration.set(CONFIG_IDENTIFIER_LITESNIPER_MAX_BRUSH_SIZE, (Object)size);
    }

    public List<Integer> getLiteSniperRestrictedItems() {
        return this.configuration.getIntegerList(CONFIG_IDENTIFIER_LITESNIPER_RESTRICTED_ITEMS);
    }

    public void setLitesniperRestrictedItems(List<Integer> restrictedItems) {
        Preconditions.checkNotNull(restrictedItems, "Restricted items must be a list.");
        this.configuration.set(CONFIG_IDENTIFIER_LITESNIPER_RESTRICTED_ITEMS, restrictedItems);
    }

    public boolean isMessageOnLoginEnabled() {
        return this.configuration.getBoolean(CONFIG_IDENTIFIER_MESSAGE_ON_LOGIN_ENABLED, true);
    }

    public void setMessageOnLoginEnabled(boolean enabled) {
        this.configuration.set(CONFIG_IDENTIFIER_MESSAGE_ON_LOGIN_ENABLED, (Object)enabled);
    }
}

