/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.block.NoteBlock;
import org.bukkit.block.Sign;
import org.bukkit.util.Vector;

public class Undo {
    private static final Set<Material> FALLING_MATERIALS = EnumSet.of(Material.WATER, Material.STATIONARY_WATER, Material.LAVA, Material.STATIONARY_LAVA);
    private static final Set<Material> FALLOFF_MATERIALS = EnumSet.of(Material.SAPLING, new Material[]{Material.BED_BLOCK, Material.POWERED_RAIL, Material.DETECTOR_RAIL, Material.LONG_GRASS, Material.DEAD_BUSH, Material.PISTON_EXTENSION, Material.YELLOW_FLOWER, Material.RED_ROSE, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.TORCH, Material.FIRE, Material.CROPS, Material.SIGN_POST, Material.WOODEN_DOOR, Material.LADDER, Material.RAILS, Material.WALL_SIGN, Material.LEVER, Material.STONE_PLATE, Material.IRON_DOOR_BLOCK, Material.WOOD_PLATE, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_ON, Material.REDSTONE_WIRE, Material.STONE_BUTTON, Material.SNOW, Material.CACTUS, Material.SUGAR_CANE_BLOCK, Material.CAKE_BLOCK, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.TRAP_DOOR, Material.PUMPKIN_STEM, Material.MELON_STEM, Material.VINE, Material.WATER_LILY, Material.NETHER_WARTS});
    private final Set<Vector> containing = Sets.newHashSet();
    private final List<BlockState> all = new LinkedList<BlockState>();
    private final List<BlockState> falloff = new LinkedList<BlockState>();
    private final List<BlockState> dropdown = new LinkedList<BlockState>();

    public int getSize() {
        return this.containing.size();
    }

    public void put(Block block) {
        Vector pos = block.getLocation().toVector();
        if (this.containing.contains(pos)) {
            return;
        }
        this.containing.add(pos);
        if (FALLING_MATERIALS.contains(block.getType())) {
            this.dropdown.add(block.getState());
        } else if (FALLOFF_MATERIALS.contains(block.getType())) {
            this.falloff.add(block.getState());
        } else {
            this.all.add(block.getState());
        }
    }

    public void undo() {
        for (BlockState blockState : this.all) {
            blockState.update(true, false);
            this.updateSpecialBlocks(blockState);
        }
        for (BlockState blockState : this.falloff) {
            blockState.update(true, false);
            this.updateSpecialBlocks(blockState);
        }
        for (BlockState blockState : this.dropdown) {
            blockState.update(true, false);
            this.updateSpecialBlocks(blockState);
        }
    }

    private void updateSpecialBlocks(BlockState blockState) {
        BlockState currentState = blockState.getBlock().getState();
        if (blockState instanceof BrewingStand && currentState instanceof BrewingStand) {
            ((BrewingStand)currentState).getInventory().setContents(((BrewingStand)blockState).getInventory().getContents());
        } else if (blockState instanceof Chest && currentState instanceof Chest) {
            ((Chest)currentState).getInventory().setContents(((Chest)blockState).getInventory().getContents());
            ((Chest)currentState).getBlockInventory().setContents(((Chest)blockState).getBlockInventory().getContents());
            currentState.update();
        } else if (blockState instanceof CreatureSpawner && currentState instanceof CreatureSpawner) {
            ((CreatureSpawner)currentState).setSpawnedType(((CreatureSpawner)currentState).getSpawnedType());
            currentState.update();
        } else if (blockState instanceof Dispenser && currentState instanceof Dispenser) {
            ((Dispenser)currentState).getInventory().setContents(((Dispenser)blockState).getInventory().getContents());
            currentState.update();
        } else if (blockState instanceof Furnace && currentState instanceof Furnace) {
            ((Furnace)currentState).getInventory().setContents(((Furnace)blockState).getInventory().getContents());
            ((Furnace)currentState).setBurnTime(((Furnace)blockState).getBurnTime());
            ((Furnace)currentState).setCookTime(((Furnace)blockState).getCookTime());
            currentState.update();
        } else if (blockState instanceof NoteBlock && currentState instanceof NoteBlock) {
            ((NoteBlock)currentState).setNote(((NoteBlock)blockState).getNote());
            currentState.update();
        } else if (blockState instanceof Sign && currentState instanceof Sign) {
            int i = 0;
            for (String text : ((Sign)blockState).getLines()) {
                ((Sign)currentState).setLine(i++, text);
            }
            currentState.update();
        }
    }
}

