/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.util;

import drew6017.lr.main.LaggRemover;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class Counter {
    private HashMap<Long, CountAction> actions = new HashMap();
    private long on;
    private long secondsDelay;
    private boolean started;

    public Counter(long secondsDelay) {
        this.secondsDelay = secondsDelay;
        this.on = secondsDelay;
        this.started = false;
    }

    public boolean start() {
        if (!this.started) {
            this.started = true;
            this.one();
        }
        return this.started;
    }

    public void reset() {
        this.on = this.secondsDelay;
        this.started = false;
    }

    private void one() {
        if (this.actions.containsKey(this.on)) {
            this.actions.get(this.on).onTrigger();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

            @Override
            public void run() {
                if (!Counter.this.started) {
                    return;
                }
                Counter.this.on--;
                if (Counter.this.on <= 0L) {
                    Counter.this.reset();
                    Counter.this.onFinish();
                } else {
                    Counter.this.one();
                }
            }
        }, 20L);
    }

    public Counter addAction(CountAction a) {
        this.actions.put(a.getTrigger(), a);
        return this;
    }

    public Counter setActions(HashMap<Long, CountAction> actions) {
        this.actions = actions;
        return this;
    }

    public boolean isActive() {
        return this.started;
    }

    public abstract void onFinish();

    public static abstract class CountAction {
        private long trigger;

        public CountAction(long trigger) {
            this.trigger = trigger;
        }

        public long getTrigger() {
            return this.trigger;
        }

        public abstract void onTrigger();
    }
}

