/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.inf;

import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.main.LaggRemover;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Help {
    private static final List<String> commandsH = new ArrayList<String>();

    public static void init() {
        commandsH.add("\u00a7e /lr help(h) <num>:\u00a77 Lists all available commands.");
        commandsH.add("\u00a7e /lr master(m) <world:none>:\u00a77 Displays a lot of information about the world and server you are in.");
        commandsH.add("\u00a7e /lr tps:\u00a77 Displays the servers TPS.");
        commandsH.add("\u00a7e /lr gc:\u00a77 Frees up RAM on your server by removing unnecessary objects stored by the system.");
        commandsH.add("\u00a7e /lr ram:\u00a77 Lists data about current RAM usage.");
        commandsH.add("\u00a7e /lr protocol(pr) <options>:\u00a77 Allows for the manual viewing/running/etc of protocols.");
        commandsH.add("\u00a7e /lr clear(c):\u00a77 Removes various entities/items.");
        commandsH.add("\u00a7e /lr count(ct):\u00a77 Counts various entities/items.");
        commandsH.add("\u00a7e /lr world(w) <world>:\u00a77 Displays stats about the world requested.");
        commandsH.add("\u00a7e /lr unload(u) <world>:\u00a77 Unloads all chunks in the world specified.");
        commandsH.add("\u00a7e /lr modules(mo):\u00a77 Lists all modules that are currently loaded by LaggRemover.");
        commandsH.add("\u00a7e /lr info(i):\u00a77 Displays info about LaggRemover. Author, copyright, etc.");
        commandsH.add("\u00a7e /lr ping(p) <player:none>:\u00a77 Shows a players ping.");
    }

    public static void send(Player p, int pageNum) {
        List<List<String>> pages = Help.getPages();
        int maxPages = pages.size();
        if (pageNum > maxPages) {
            Help.sendMsg(p, "\u00a7cHelp page #" + Integer.toString(pageNum) + " does not exist.", true);
        } else {
            Help.sendMsg(p, "\u00a73---------========== Help Page (\u00a7b" + Integer.toString(pageNum) + "\u00a73/\u00a7b" + Integer.toString(maxPages) + "\u00a73) ==========---------", false);
            for (String s : pages.get(pageNum - 1)) {
                Help.sendMsg(p, s, false);
            }
        }
    }

    public static void sendMsg(Player p, String msg, boolean pre) {
        if (p == null) {
            LaggRemover.lr.getLogger().info(ChatColor.stripColor((String)msg));
        } else {
            if (pre) {
                msg = LaggRemover.prefix + msg;
            }
            p.sendMessage(msg);
        }
    }

    public static void addCommandH(String cmd) {
        commandsH.add(cmd);
    }

    private static List<List<String>> getPages() {
        ArrayList<List<String>> h = new ArrayList<List<String>>();
        ArrayList<String> c = new ArrayList<String>();
        for (String s : commandsH) {
            if (c.size() == 6) {
                h.add(c);
                c = new ArrayList();
            }
            c.add(s);
        }
        if (!c.isEmpty()) {
            h.add(c);
        }
        return h;
    }

    public static void sendProtocolResultInfo(Player p, LRProtocolResult r) {
        StringBuilder s = new StringBuilder();
        s.append("{");
        int i = 0;
        for (Object o : r.getData()) {
            s.append(i).append(": ").append(o).append(", ");
            ++i;
        }
        String fin = s.toString();
        fin = s.substring(0, fin.length() - 2) + "}";
        Help.sendMsg(p, "\u00a7eProtocol: " + r.getSuper().id() + " | \u00a77" + fin, true);
    }
}

