/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.bugfixes.world.chunksaving.mixin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class UTChunkSavingMixin {
    private final Map<ChunkPos, NBTTagCompound> chunksInWrite = new HashMap<ChunkPos, NBTTagCompound>();
    @Shadow
    @Final
    public File field_75825_d;
    @Shadow
    @Final
    private Map<ChunkPos, NBTTagCompound> field_75828_a;
    @Shadow
    private boolean field_183014_e;

    @Shadow
    protected abstract void func_183013_b(ChunkPos var1, NBTTagCompound var2) throws IOException;

    private synchronized void queueChunkToSave(ChunkPos pos, NBTTagCompound data) {
        this.field_75828_a.put(pos, data);
    }

    private synchronized Map.Entry<ChunkPos, NBTTagCompound> fetchChunkToWrite() {
        if (this.field_75828_a.isEmpty()) {
            return null;
        }
        Set<Map.Entry<ChunkPos, NBTTagCompound>> entrySet = this.field_75828_a.entrySet();
        Iterator<Map.Entry<ChunkPos, NBTTagCompound>> iter = entrySet.iterator();
        Map.Entry<ChunkPos, NBTTagCompound> entry = iter.next();
        iter.remove();
        this.chunksInWrite.put(entry.getKey(), entry.getValue());
        return entry;
    }

    private synchronized void retireChunkToWrite(ChunkPos pos, NBTTagCompound data) {
        this.chunksInWrite.remove(pos);
    }

    private synchronized NBTTagCompound reloadChunkFromSaveQueues(ChunkPos pos) {
        NBTTagCompound data = this.field_75828_a.get(pos);
        if (data != null) {
            return data;
        }
        return this.chunksInWrite.get(pos);
    }

    private synchronized boolean chunkExistInSaveQueues(ChunkPos pos) {
        return this.field_75828_a.containsKey(pos) || this.chunksInWrite.containsKey(pos);
    }

    @Redirect(method={"loadChunk__Async"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0, remap=false), remap=false)
    private Object utPullChunkToSave(Map lChunksToSave, Object lpos) {
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTChunkSaving ::: Pull chunk to save");
        }
        return this.reloadChunkFromSaveQueues((ChunkPos)lpos);
    }

    @Inject(method={"isChunkGeneratedAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void utOverrideIsChunkGeneratedAt(int x, int z, CallbackInfoReturnable<Boolean> ci) {
        ChunkPos chunkpos;
        boolean exists;
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTChunkSaving ::: Check chunk generation");
        }
        ci.setReturnValue((Object)((exists = this.chunkExistInSaveQueues(chunkpos = new ChunkPos(x, z))) || RegionFileCache.func_191064_f((File)this.field_75825_d, (int)x, (int)z) ? 1 : 0));
    }

    @Redirect(method={"addChunkToPending"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean utOverrideAddChunkToPending(Set lChunksBeingSaved, Object lPos, ChunkPos pos, NBTTagCompound compound) {
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTChunkSaving ::: Add chunk to pending");
        }
        this.queueChunkToSave(pos, compound);
        return true;
    }

    @Inject(method={"writeNextIO"}, at={@At(value="HEAD")}, cancellable=true)
    private void utOverrideWriteNextIO(CallbackInfoReturnable<Boolean> ci) {
        Map.Entry<ChunkPos, NBTTagCompound> entry;
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTChunkSaving ::: Write next IO");
        }
        if ((entry = this.fetchChunkToWrite()) == null) {
            if (this.field_183014_e) {
                UniversalTweaks.LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", new Object[]{this.field_75825_d.getName()});
            }
            ci.setReturnValue((Object)false);
            return;
        }
        ChunkPos chunkpos = entry.getKey();
        NBTTagCompound nbttagcompound = entry.getValue();
        try {
            this.func_183013_b(chunkpos, nbttagcompound);
        }
        catch (Exception exception) {
            UniversalTweaks.LOGGER.error("Failed to save chunk", (Throwable)exception);
        }
        this.retireChunkToWrite(chunkpos, nbttagcompound);
        ci.setReturnValue((Object)true);
    }
}

