/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import com.destroystokyo.paper.MaterialSetTag;
import com.destroystokyo.paper.MaterialTags;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.ess3.provider.MaterialTagProvider;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;

public class PaperMaterialTagProvider
implements MaterialTagProvider {
    private final Map<String, Tag<Material>> bukkitTagMap = new HashMap<String, Tag<Material>>();
    private final Map<String, MaterialSetTag> paperTagMap = new HashMap<String, MaterialSetTag>();

    @Override
    public boolean tagExists(String tagName) {
        if (tagName == null) {
            return false;
        }
        return this.getBukkitTag(tagName) != null || this.getPaperTag(tagName) != null;
    }

    @Override
    public boolean isTagged(String tagName, Material material) {
        if (tagName == null) {
            return false;
        }
        if (this.getBukkitTag(tagName) != null) {
            return this.getBukkitTag(tagName).isTagged((Keyed)material);
        }
        if (this.getPaperTag(tagName) != null) {
            return this.getPaperTag(tagName).isTagged(material);
        }
        return false;
    }

    private MaterialSetTag getPaperTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (!this.paperTagMap.containsKey(tagName = tagName.toUpperCase())) {
            try {
                Field field = MaterialTags.class.getDeclaredField(tagName.toUpperCase());
                this.paperTagMap.put(tagName, (MaterialSetTag)field.get(null));
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                this.paperTagMap.put(tagName, null);
            }
        }
        return this.paperTagMap.get(tagName);
    }

    private Tag<Material> getBukkitTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (!this.bukkitTagMap.containsKey(tagName = tagName.toUpperCase())) {
            try {
                Field field = Tag.class.getDeclaredField(tagName.toUpperCase());
                this.bukkitTagMap.put(tagName, (Tag<Material>)((Tag)field.get(null)));
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                this.bukkitTagMap.put(tagName, null);
            }
        }
        return this.bukkitTagMap.get(tagName);
    }
}

