/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class Commandunban
extends EssentialsCommand {
    public Commandunban() {
        super("unban");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String name;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        try {
            User user = this.getPlayer(server, args, 0, true, true);
            name = user.getName();
            this.ess.getServer().getBanList(BanList.Type.NAME).pardon(name);
        }
        catch (PlayerNotFoundException e) {
            OfflinePlayer player = server.getOfflinePlayer(args[0]);
            name = player.getName();
            if (!player.isBanned()) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[0]));
            }
            this.ess.getServer().getBanList(BanList.Type.NAME).pardon(name);
        }
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        this.ess.getLogger().log(Level.INFO, I18n.tl("playerUnbanned", senderDisplayName, name));
        this.ess.broadcastMessage("essentials.ban.notify", I18n.tl("playerUnbanned", senderDisplayName, name));
    }
}

