/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Server;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpo
extends EssentialsCommand {
    public Commandtpo() {
        super("tpo");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        switch (args.length) {
            case 0: {
                throw new NotEnoughArgumentsException();
            }
            case 1: {
                User player = this.getPlayer(server, user, args, 0);
                if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + player.getWorld().getName())) {
                    throw new Exception(I18n.tl("noPerm", "essentials.worlds." + player.getWorld().getName()));
                }
                user.getAsyncTeleport().now(player.getBase(), false, PlayerTeleportEvent.TeleportCause.COMMAND, this.getNewExceptionFuture(user.getSource(), commandLabel));
                break;
            }
            default: {
                if (!user.isAuthorized("essentials.tp.others")) {
                    throw new Exception(I18n.tl("noPerm", "essentials.tp.others"));
                }
                User target = this.getPlayer(server, user, args, 0);
                User toPlayer = this.getPlayer(server, user, args, 1);
                if (target.getWorld() != toPlayer.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + toPlayer.getWorld().getName())) {
                    throw new Exception(I18n.tl("noPerm", "essentials.worlds." + toPlayer.getWorld().getName()));
                }
                CompletableFuture<Boolean> future = this.getNewExceptionFuture(user.getSource(), commandLabel);
                target.getAsyncTeleport().now(toPlayer.getBase(), false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
                future.thenAccept(success -> {
                    if (success.booleanValue()) {
                        target.sendMessage(I18n.tl("teleportAtoB", user.getDisplayName(), toPlayer.getDisplayName()));
                    }
                });
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1 || args.length == 2 && user.isAuthorized("essentials.tp.others")) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

