/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Commandtempbanip
extends EssentialsCommand {
    public Commandtempbanip() {
        super("tempbanip");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String ipAddress;
        String senderDisplayName;
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        String senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        String string = senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        if (FormatUtil.validIP(args[0])) {
            ipAddress = args[0];
        } else {
            try {
                User player = this.getPlayer(server, args, 0, true, true);
                ipAddress = player.getLastLoginAddress();
            }
            catch (PlayerNotFoundException ex) {
                ipAddress = args[0];
            }
        }
        if (ipAddress.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        String time = Commandtempbanip.getFinalArg(args, 1);
        long banTimestamp = DateUtil.parseDateDiff(time, true);
        String banReason = DateUtil.removeTimePattern(time);
        long maxBanLength = this.ess.getSettings().getMaxTempban() * 1000L;
        if (maxBanLength > 0L && banTimestamp - GregorianCalendar.getInstance().getTimeInMillis() > maxBanLength && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.tempban.unlimited")) {
            sender.sendMessage(I18n.tl("oversizedTempban", new Object[0]));
            return;
        }
        if (banReason.length() < 2) {
            banReason = I18n.tl("defaultBanReason", new Object[0]);
        }
        this.ess.getServer().getBanList(BanList.Type.IP).addBan(ipAddress, banReason, new Date(banTimestamp), senderName);
        String banDisplay = I18n.tl("banFormat", banReason, senderDisplayName);
        for (Player player : this.ess.getServer().getOnlinePlayers()) {
            if (!player.getAddress().getAddress().getHostAddress().equalsIgnoreCase(ipAddress)) continue;
            player.kickPlayer(banDisplay);
        }
        String message = I18n.tl("playerTempBanIpAddress", senderDisplayName, ipAddress, DateUtil.formatDateDiff(banTimestamp), banReason);
        this.ess.getLogger().log(Level.INFO, message);
        this.ess.broadcastMessage("essentials.banip.notify", message);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return COMMON_DATE_DIFFS;
    }
}

