/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.OfflinePlayerStub;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.DateUtil;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import net.ess3.api.events.MuteStatusChangeEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandmute
extends EssentialsCommand {
    public Commandmute() {
        super("mute");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User user;
        boolean nomatch = false;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        try {
            user = this.getPlayer(server, args, 0, true, true);
        }
        catch (PlayerNotFoundException e) {
            nomatch = true;
            user = this.ess.getUser(new OfflinePlayerStub(args[0], this.ess.getServer()));
        }
        if (!user.getBase().isOnline() && sender.isPlayer()) {
            if (!sender.isAuthorized("essentials.mute.offline", this.ess)) {
                throw new Exception(I18n.tl("muteExemptOffline", new Object[0]));
            }
        } else if (user.isAuthorized("essentials.mute.exempt")) {
            throw new Exception(I18n.tl("muteExempt", new Object[0]));
        }
        long muteTimestamp = 0L;
        String muteReason = null;
        if (args.length > 1) {
            String time = args[1];
            try {
                muteTimestamp = DateUtil.parseDateDiff(time, true);
                muteReason = Commandmute.getFinalArg(args, 2);
            }
            catch (Exception e) {
                muteReason = Commandmute.getFinalArg(args, 1);
            }
            long maxMuteLength = this.ess.getSettings().getMaxMute() * 1000L;
            if (maxMuteLength > 0L && muteTimestamp - GregorianCalendar.getInstance().getTimeInMillis() > maxMuteLength && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.mute.unlimited")) {
                sender.sendMessage(I18n.tl("oversizedMute", new Object[0]));
                throw new NoChargeException();
            }
        }
        boolean willMute = args.length > 1 || !user.getMuted();
        User controller = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null;
        MuteStatusChangeEvent event = new MuteStatusChangeEvent(user, controller, willMute, muteTimestamp, muteReason);
        this.ess.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (muteReason != null) {
                user.setMuteReason(muteReason.isEmpty() ? null : muteReason);
                user.setMuted(true);
            } else {
                user.setMuted(!user.getMuted());
                if (!user.getMuted()) {
                    user.setMuteReason(null);
                }
            }
            user.setMuteTimeout(muteTimestamp);
            boolean muted = user.getMuted();
            String muteTime = DateUtil.formatDateDiff(muteTimestamp);
            if (nomatch) {
                sender.sendMessage(I18n.tl("userUnknown", user.getName()));
            }
            if (muted) {
                if (muteTimestamp > 0L) {
                    if (!user.hasMuteReason()) {
                        sender.sendMessage(I18n.tl("mutedPlayerFor", user.getDisplayName(), muteTime));
                        user.sendMessage(I18n.tl("playerMutedFor", muteTime));
                    } else {
                        sender.sendMessage(I18n.tl("mutedPlayerForReason", user.getDisplayName(), muteTime, user.getMuteReason()));
                        user.sendMessage(I18n.tl("playerMutedForReason", muteTime, user.getMuteReason()));
                    }
                } else if (!user.hasMuteReason()) {
                    sender.sendMessage(I18n.tl("mutedPlayer", user.getDisplayName()));
                    user.sendMessage(I18n.tl("playerMuted", new Object[0]));
                } else {
                    sender.sendMessage(I18n.tl("mutedPlayerReason", user.getDisplayName(), user.getMuteReason()));
                    user.sendMessage(I18n.tl("playerMutedReason", user.getMuteReason()));
                }
                String message = muteTimestamp > 0L ? (!user.hasMuteReason() ? I18n.tl("muteNotifyFor", sender.getSender().getName(), user.getName(), muteTime) : I18n.tl("muteNotifyForReason", sender.getSender().getName(), user.getName(), muteTime, user.getMuteReason())) : (!user.hasMuteReason() ? I18n.tl("muteNotify", sender.getSender().getName(), user.getName()) : I18n.tl("muteNotifyReason", sender.getSender().getName(), user.getName(), user.getMuteReason()));
                this.ess.getLogger().log(Level.INFO, message);
                this.ess.broadcastMessage("essentials.mute.notify", message);
            } else {
                sender.sendMessage(I18n.tl("unmutedPlayer", user.getDisplayName()));
                user.sendMessage(I18n.tl("playerUnmuted", new Object[0]));
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return COMMON_DATE_DIFFS;
    }
}

