/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.messaging.SimpleMessageRecipient;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class Console
implements IMessageRecipient {
    public static final String NAME = "Console";
    public static final String DISPLAY_NAME = I18n.tl("consoleName", new Object[0]);
    private static Console instance;
    private final IEssentials ess;
    private final IMessageRecipient messageRecipient;

    private Console(IEssentials ess) {
        this.ess = ess;
        this.messageRecipient = new SimpleMessageRecipient(ess, this);
    }

    public static Console getInstance() {
        return instance;
    }

    static void setInstance(IEssentials ess) {
        instance = new Console(ess);
    }

    @Deprecated
    public static CommandSender getCommandSender(Server server) throws Exception {
        return server.getConsoleSender();
    }

    public CommandSender getCommandSender() {
        return this.ess.getServer().getConsoleSender();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public UUID getUUID() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void sendMessage(String message) {
        this.getCommandSender().sendMessage(message);
    }

    @Override
    public boolean isReachable() {
        return true;
    }

    @Override
    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        return this.messageRecipient.sendMessage(recipient, message);
    }

    @Override
    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        return this.messageRecipient.onReceiveMessage(sender, message);
    }

    @Override
    public IMessageRecipient getReplyRecipient() {
        return this.messageRecipient.getReplyRecipient();
    }

    @Override
    public void setReplyRecipient(IMessageRecipient recipient) {
        this.messageRecipient.setReplyRecipient(recipient);
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        return false;
    }
}

