/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.AsyncTeleport;
import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ITarget;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerTeleportEvent;

public class AsyncTimedTeleport
implements Runnable {
    private static final double MOVE_CONSTANT = 0.3;
    private final IUser teleportOwner;
    private final IEssentials ess;
    private final AsyncTeleport teleport;
    private final UUID timer_teleportee;
    private final long timer_started;
    private final long timer_delay;
    private final CompletableFuture<Boolean> parentFuture;
    private final long timer_initX;
    private final long timer_initY;
    private final long timer_initZ;
    private final ITarget timer_teleportTarget;
    private final boolean timer_respawn;
    private final boolean timer_canMove;
    private final Trade timer_chargeFor;
    private final PlayerTeleportEvent.TeleportCause timer_cause;
    private int timer_task;
    private double timer_health;

    AsyncTimedTeleport(IUser user, IEssentials ess, AsyncTeleport teleport, long delay, IUser teleportUser, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, boolean respawn) {
        this(user, ess, teleport, delay, null, teleportUser, target, chargeFor, cause, respawn);
    }

    AsyncTimedTeleport(IUser user, IEssentials ess, AsyncTeleport teleport, long delay, CompletableFuture<Boolean> future, IUser teleportUser, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, boolean respawn) {
        this.teleportOwner = user;
        this.ess = ess;
        this.teleport = teleport;
        this.timer_started = System.currentTimeMillis();
        this.timer_delay = delay;
        this.timer_health = teleportUser.getBase().getHealth();
        this.timer_initX = Math.round(teleportUser.getBase().getLocation().getX() * 0.3);
        this.timer_initY = Math.round(teleportUser.getBase().getLocation().getY() * 0.3);
        this.timer_initZ = Math.round(teleportUser.getBase().getLocation().getZ() * 0.3);
        this.timer_teleportee = teleportUser.getBase().getUniqueId();
        this.timer_teleportTarget = target;
        this.timer_chargeFor = chargeFor;
        this.timer_cause = cause;
        this.timer_respawn = respawn;
        this.timer_canMove = user.isAuthorized("essentials.teleport.timer.move");
        this.timer_task = ess.runTaskTimerAsynchronously(this, 20L, 20L).getTaskId();
        if (future != null) {
            this.parentFuture = future;
            return;
        }
        CompletableFuture cFuture = new CompletableFuture();
        cFuture.exceptionally(e -> {
            ess.showError(this.teleportOwner.getSource(), (Throwable)e, "\\ teleport");
            return false;
        });
        this.parentFuture = cFuture;
    }

    @Override
    public void run() {
        if (this.teleportOwner == null || !this.teleportOwner.getBase().isOnline() || this.teleportOwner.getBase().getLocation() == null) {
            this.cancelTimer(false);
            return;
        }
        final User teleportUser = this.ess.getUser(this.timer_teleportee);
        if (teleportUser == null || !teleportUser.getBase().isOnline()) {
            this.cancelTimer(false);
            return;
        }
        Location currLocation = teleportUser.getBase().getLocation();
        if (currLocation == null) {
            this.cancelTimer(false);
            return;
        }
        if (!this.timer_canMove && (Math.round(currLocation.getX() * 0.3) != this.timer_initX || Math.round(currLocation.getY() * 0.3) != this.timer_initY || Math.round(currLocation.getZ() * 0.3) != this.timer_initZ || teleportUser.getBase().getHealth() < this.timer_health)) {
            this.cancelTimer(true);
            return;
        }
        class DelayedTeleportTask
        implements Runnable {
            DelayedTeleportTask() {
            }

            @Override
            public void run() {
                AsyncTimedTeleport.this.timer_health = teleportUser.getBase().getHealth();
                long now = System.currentTimeMillis();
                if (now > AsyncTimedTeleport.this.timer_started + AsyncTimedTeleport.this.timer_delay) {
                    block8: {
                        try {
                            AsyncTimedTeleport.this.teleport.cooldown(false);
                        }
                        catch (Throwable ex) {
                            AsyncTimedTeleport.this.teleportOwner.sendMessage(I18n.tl("cooldownWithMessage", ex.getMessage()));
                            if (AsyncTimedTeleport.this.teleportOwner == teleportUser) break block8;
                            teleportUser.sendMessage(I18n.tl("cooldownWithMessage", ex.getMessage()));
                        }
                    }
                    try {
                        AsyncTimedTeleport.this.cancelTimer(false);
                        teleportUser.sendMessage(I18n.tl("teleportationCommencing", new Object[0]));
                        if (AsyncTimedTeleport.this.timer_chargeFor != null) {
                            AsyncTimedTeleport.this.timer_chargeFor.isAffordableFor(AsyncTimedTeleport.this.teleportOwner);
                        }
                        if (AsyncTimedTeleport.this.timer_respawn) {
                            AsyncTimedTeleport.this.teleport.respawnNow(teleportUser, AsyncTimedTeleport.this.timer_cause, AsyncTimedTeleport.this.parentFuture);
                        } else {
                            AsyncTimedTeleport.this.teleport.nowAsync(teleportUser, AsyncTimedTeleport.this.timer_teleportTarget, AsyncTimedTeleport.this.timer_cause, AsyncTimedTeleport.this.parentFuture);
                        }
                        AsyncTimedTeleport.this.parentFuture.thenAccept(success -> {
                            if (AsyncTimedTeleport.this.timer_chargeFor != null) {
                                try {
                                    AsyncTimedTeleport.this.timer_chargeFor.charge(AsyncTimedTeleport.this.teleportOwner);
                                }
                                catch (ChargeException ex) {
                                    AsyncTimedTeleport.this.ess.showError(AsyncTimedTeleport.this.teleportOwner.getSource(), ex, "\\ teleport");
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        AsyncTimedTeleport.this.ess.showError(AsyncTimedTeleport.this.teleportOwner.getSource(), ex, "\\ teleport");
                    }
                }
            }
        }
        this.ess.scheduleSyncDelayedTask(new DelayedTeleportTask());
    }

    void cancelTimer(boolean notifyUser) {
        if (this.timer_task == -1) {
            return;
        }
        try {
            this.ess.getServer().getScheduler().cancelTask(this.timer_task);
            if (notifyUser) {
                this.teleportOwner.sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
                if (this.timer_teleportee != null && !this.timer_teleportee.equals(this.teleportOwner.getBase().getUniqueId())) {
                    this.ess.getUser(this.timer_teleportee).sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
                }
            }
        }
        finally {
            this.timer_task = -1;
        }
    }
}

