/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.drop.DropContainer;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLuckyProjectile
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityLuckyProjectile.class, (DataSerializer)DataSerializers.field_187191_a);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    protected boolean inGround;
    protected int field_184552_b;
    public EntityArrow.PickupStatus canBePickedUp = EntityArrow.PickupStatus.DISALLOWED;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0;
    private int knockbackStrength;
    private static final DataParameter<ItemStack> PROJECTILE_ITEM = EntityDataManager.func_187226_a(EntityLuckyProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private EntityItem item;
    private boolean hasTrail = false;
    private float trailFrequency = 1.0f;
    private boolean hasImpact = false;
    private DropProcessor dropProcessorTrail;
    private DropProcessor dropProcessorImpact;

    public EntityLuckyProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityLuckyProjectile(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityLuckyProjectile(World worldIn, EntityLivingBase shooter) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    private void luckyImpact(Entity entityHit) {
        try {
            if (this.hasImpact) {
                if (entityHit == null) {
                    this.dropProcessorImpact.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.shootingEntity, this.func_174791_d()), 0);
                } else {
                    this.dropProcessorImpact.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.shootingEntity, entityHit.func_174791_d()).setHitEntity(entityHit), 0);
                }
            }
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70106_y();
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Bow encountered and error while trying to perform an impact function. Error report below:");
            e.printStackTrace();
        }
        this.func_70106_y();
    }

    private void luckyUpdate() {
        try {
            if (this.item == null && this.func_130014_f_().field_72995_K) {
                this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, (ItemStack)this.field_70180_af.func_187225_a(PROJECTILE_ITEM));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.item != null) {
            this.item.func_70071_h_();
        }
        if (!this.func_130014_f_().field_72995_K && this.hasTrail && this.ticksInAir >= 2) {
            try {
                if ((double)this.trailFrequency < 1.0 && this.trailFrequency > 0.0f) {
                    int amount = (int)(1.0 / (double)this.trailFrequency);
                    for (int i = 0; i < amount; ++i) {
                        this.dropProcessorTrail.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.shootingEntity, new Vec3d(this.field_70165_t + this.field_70159_w * (double)i / (double)amount, this.field_70163_u + this.field_70181_x * (double)i / (double)amount, this.field_70161_v + this.field_70179_y * (double)i / (double)amount)), 0, false);
                    }
                } else if ((this.ticksInAir - 2) % (int)this.trailFrequency == 0) {
                    this.dropProcessorTrail.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.shootingEntity, this.func_174791_d()), 0, false);
                }
            }
            catch (Exception e) {
                System.err.println("The Lucky Bow encountered and error while trying to perform a trail function. Error report below:");
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityLuckyProjectile.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PROJECTILE_ITEM, (Object)new ItemStack(Items.field_151055_y));
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.dropProcessorTrail = new DropProcessor();
        this.dropProcessorImpact = new DropProcessor();
    }

    public void func_184547_a(Entity p_184547_1_, float p_184547_2_, float p_184547_3_, float p_184547_4_, float p_184547_5_, float p_184547_6_) {
        float f = -MathHelper.func_76126_a((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, p_184547_5_, p_184547_6_);
        this.field_70159_w += p_184547_1_.field_70159_w;
        this.field_70179_y += p_184547_1_.field_70179_y;
        if (!p_184547_1_.field_70122_E) {
            this.field_70181_x += p_184547_1_.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int j = block.func_176201_c(iblockstate);
            if (block == this.inTile && j == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
            ++this.field_184552_b;
            this.luckyImpact(null);
            this.luckyUpdate();
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && (this.ticksInAir > 5 || raytraceresult.field_72308_g != this.shootingEntity && this.shootingEntity != null)) {
                this.onHit(raytraceresult);
                this.luckyImpact(raytraceresult.field_72308_g);
            }
            if (this.getIsCritical()) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            this.luckyUpdate();
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f1 = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            this.field_70181_x -= (double)f2;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected void onHit(RayTraceResult p_184549_1_) {
        Entity entity = p_184549_1_.field_72308_g;
        if (entity != null) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * this.damage));
            if (this.getIsCritical()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = null;
            if (this.shootingEntity == null) {
                damagesource = DamageSource.func_188403_a((Entity)this, null);
            } else if (this.shootingEntity instanceof EntityLivingBase) {
                damagesource = DamageSource.func_188403_a((Entity)this, (EntityLivingBase)((EntityLivingBase)this.shootingEntity));
            }
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.shootingEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                    }
                    this.arrowHit(entitylivingbase);
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    if (this.canBePickedUp == EntityArrow.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.getArrowStack(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            BlockPos blockpos = p_184549_1_.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(p_184549_1_.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(p_184549_1_.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(p_184549_1_.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            this.arrowShake = 7;
            this.setIsCritical(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    protected void arrowHit(EntityLivingBase living) {
        this.func_70106_y();
    }

    protected Entity func_184551_a(Vec3d p_184551_1_, Vec3d p_184551_2_) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(p_184551_1_, p_184551_2_)) == null || !((d1 = p_184551_1_.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("xTile", this.xTile);
        tagCompound.func_74768_a("yTile", this.yTile);
        tagCompound.func_74768_a("zTile", this.zTile);
        tagCompound.func_74777_a("life", (short)this.ticksInGround);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("inData", (byte)this.inData);
        tagCompound.func_74774_a("shake", (byte)this.arrowShake);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tagCompound.func_74774_a("pickup", (byte)this.canBePickedUp.ordinal());
        tagCompound.func_74780_a("damage", this.damage);
        this.customWriteEntityToNBT(tagCompound);
    }

    private void customWriteEntityToNBT(NBTTagCompound tagCompound) {
        if (this.item != null) {
            tagCompound.func_74782_a("item", (NBTBase)this.item.func_92059_d().func_77955_b(new NBTTagCompound()));
        }
        if (this.hasTrail) {
            NBTTagCompound trailTag = new NBTTagCompound();
            trailTag.func_74776_a("frequency", this.trailFrequency);
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorTrail.getDrops().size(); ++i) {
                drops.func_74742_a((NBTBase)new NBTTagString(this.dropProcessorTrail.getDrops().get(i).toString()));
            }
            trailTag.func_74782_a("drops", (NBTBase)drops);
            tagCompound.func_74782_a("trail", (NBTBase)trailTag);
        }
        if (this.hasImpact) {
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorImpact.getDrops().size(); ++i) {
                drops.func_74742_a((NBTBase)new NBTTagString(this.dropProcessorImpact.getDrops().get(i).toString()));
            }
            tagCompound.func_74782_a("impact", (NBTBase)drops);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74762_e("xTile");
        this.yTile = tagCompund.func_74762_e("yTile");
        this.zTile = tagCompund.func_74762_e("zTile");
        this.ticksInGround = tagCompund.func_74765_d("life");
        this.inTile = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        this.inData = tagCompund.func_74771_c("inData") & 0xFF;
        this.arrowShake = tagCompund.func_74771_c("shake") & 0xFF;
        boolean bl = this.inGround = tagCompund.func_74771_c("inGround") == 1;
        if (tagCompund.func_150297_b("damage", 99)) {
            this.damage = tagCompund.func_74769_h("damage");
        }
        if (tagCompund.func_150297_b("pickup", 99)) {
            this.canBePickedUp = EntityArrow.PickupStatus.func_188795_a((int)tagCompund.func_74771_c("pickup"));
        } else if (tagCompund.func_150297_b("player", 99)) {
            this.canBePickedUp = tagCompund.func_74767_n("player") ? EntityArrow.PickupStatus.ALLOWED : EntityArrow.PickupStatus.DISALLOWED;
        }
        this.customReadEntityFromNBT(tagCompund);
    }

    private void customReadEntityFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("item")) {
            tagCompound.func_74775_l("item").func_74782_a("Count", (NBTBase)new NBTTagInt(1));
            this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(tagCompound.func_74775_l("item")));
        } else {
            this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151055_y));
        }
        this.field_70180_af.func_187227_b(PROJECTILE_ITEM, (Object)this.item.func_92059_d());
        if (tagCompound.func_74764_b("trail")) {
            NBTTagCompound trailTag = tagCompound.func_74775_l("trail");
            if (trailTag.func_74764_b("frequency")) {
                this.trailFrequency = trailTag.func_74760_g("frequency");
            }
            if (trailTag.func_74764_b("drops")) {
                NBTTagList drops = trailTag.func_150295_c("drops", (int)new NBTTagString().func_74732_a());
                for (int i = 0; i < drops.func_74745_c(); ++i) {
                    DropContainer drop = new DropContainer();
                    drop.readFromString(drops.func_150307_f(i));
                    this.dropProcessorTrail.registerDrop(drop);
                }
            }
            this.hasTrail = true;
        }
        if (tagCompound.func_74764_b("impact")) {
            NBTTagList drops = tagCompound.func_150295_c("impact", (int)new NBTTagString().func_74732_a());
            for (int i = 0; i < drops.func_74745_c(); ++i) {
                DropContainer drop = new DropContainer();
                drop.readFromString(drops.func_150307_f(i));
                this.dropProcessorImpact.registerDrop(drop);
            }
            this.hasImpact = true;
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == EntityArrow.PickupStatus.ALLOWED || this.canBePickedUp == EntityArrow.PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == EntityArrow.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected ItemStack getArrowStack() {
        return new ItemStack(Items.field_151032_g);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setIsCritical(boolean critical) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (critical) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public EntityItem getItem() {
        return this.item;
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int p_188795_0_) {
            if (p_188795_0_ < 0 || p_188795_0_ > PickupStatus.values().length) {
                p_188795_0_ = 0;
            }
            return PickupStatus.values()[p_188795_0_];
        }
    }
}

