/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_12_2;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.Log;
import org.dynmap.forge_1_12_2.DynmapPlugin;
import org.dynmap.forge_1_12_2.Proxy;
import org.dynmap.modsupport.ModSupportImpl;

@Mod(modid="dynmap", name="Dynmap", version="3.0.1-343")
public class DynmapMod {
    @Mod.Instance(value="dynmap")
    public static DynmapMod instance;
    @SidedProxy(clientSide="org.dynmap.forge_1_12_2.ClientProxy", serverSide="org.dynmap.forge_1_12_2.Proxy")
    public static Proxy proxy;
    public static DynmapPlugin plugin;
    public static File jarfile;
    public static boolean useforcedchunks;
    private MinecraftServer server;

    public DynmapMod() {
        Log.setLogger(new DynmapPlugin.OurLog());
        ModSupportImpl.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        jarfile = event.getSourceFile();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            useforcedchunks = cfg.get("Settings", "UseForcedChunks", true).getBoolean(true);
        }
        finally {
            cfg.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (useforcedchunks) {
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new LoadingCallback());
        } else {
            System.out.println("[Dynmap] World loading using forced chunks is disabled");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        DynmapCommonAPIListener.register(new APICallback());
        if (plugin == null) {
            plugin = proxy.startServer(this.server);
        }
        plugin.serverStarted();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        proxy.stopServer(plugin);
        plugin = null;
    }

    @NetworkCheckHandler
    public boolean netCheckHandler(Map<String, String> mods, Side side) {
        return true;
    }

    public class LoadingCallback
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            if (tickets.size() > 0) {
                DynmapPlugin.setBusy(world, tickets.get(0));
                for (int i = 1; i < tickets.size(); ++i) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)tickets.get(i));
                }
            }
        }
    }

    public class APICallback
    extends DynmapCommonAPIListener {
        @Override
        public void apiListenerAdded() {
            if (plugin == null) {
                plugin = proxy.startServer(DynmapMod.this.server);
            }
        }

        @Override
        public void apiEnabled(DynmapCommonAPI api) {
        }
    }
}

