/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import com.github.cpburnz.minecraft_prometheus_exporter.Config;
import com.github.cpburnz.minecraft_prometheus_exporter.MinecraftCollector;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.CollectorRegistry;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.exporter.HTTPServer;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="prometheus_exporter", useMetadata=true, acceptableRemoteVersions="*")
public class PrometheusExporterMod {
    private static final Logger LOG = LogManager.getLogger();
    public static final String MOD_ID = "prometheus_exporter";
    private HTTPServer http_server;
    private MinecraftCollector mc_collector;
    private MinecraftServer mc_server;
    private Config config;

    public PrometheusExporterMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config = new Config();
    }

    private void closeCollectors() {
        CollectorRegistry.defaultRegistry.clear();
    }

    private void closeHttpServer() {
        this.http_server.close();
    }

    private void initCollectors() {
        if (this.config.collector_jvm) {
            DefaultExports.initialize();
        }
        if (this.config.collector_mc) {
            this.mc_collector = new MinecraftCollector(this.mc_server);
            this.mc_collector.register();
        }
    }

    private void initHttpServer() throws IOException {
        String address = this.config.web_listen_address;
        int port = this.config.web_listen_port;
        this.http_server = new HTTPServer(address, port, true);
        LOG.info("Listening on {}:{}", (Object)address, (Object)port);
    }

    @SubscribeEvent
    public void onDimensionTick(TickEvent.WorldTickEvent event) {
        if (this.mc_collector != null) {
            DimensionType dim = event.world.field_73011_w.func_186058_p();
            if (event.phase == TickEvent.Phase.START) {
                this.mc_collector.startDimensionTick(dim);
            } else if (event.phase == TickEvent.Phase.END) {
                this.mc_collector.stopDimensionTick(dim);
            }
        }
    }

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent event) {
        this.config.loadValues(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void onServerStaring(FMLServerStartingEvent event) {
        this.mc_server = event.getServer();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) throws IOException {
        this.initHttpServer();
        this.initCollectors();
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        this.closeCollectors();
        this.closeHttpServer();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.mc_collector != null) {
            if (event.phase == TickEvent.Phase.START) {
                this.mc_collector.startServerTick();
            } else if (event.phase == TickEvent.Phase.END) {
                this.mc_collector.stopServerTick();
            }
        }
    }
}

