/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.util;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MojangNameLookup {
    private static final Logger logger = LogManager.getFormatterLogger(MojangNameLookup.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String lookupName(UUID id) {
        if (id == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + id.toString().replace("-", ""));
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setUseCaches(false);
            inputStream = connection.getInputStream();
            String result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            Gson gson = new Gson();
            Response response = (Response)gson.fromJson(result, Response.class);
            if (response == null || response.name == null) {
                logger.warn("Failed to lookup name from UUID");
                String string = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                return string;
            }
            if (response.cause != null && response.cause.length() > 0) {
                logger.warn("Failed to lookup name from UUID: %s", (Object)response.errorMessage);
                String string = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                return string;
            }
            String string = response.name;
            IOUtils.closeQuietly((InputStream)inputStream);
            return string;
        }
        catch (MalformedURLException ex2) {
            logger.warn("Malformed URL in UUID lookup");
            String string = null;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException ex3) {
                IOUtils.closeQuietly(inputStream);
                return null;
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private static class Response {
        String errorMessage;
        String cause;
        String name;

        private Response() {
        }
    }
}

