/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.forge.ForgeInjectBukkit;
import com.mohistmc.forge.ModCompatibleFixUtils;
import com.mohistmc.forge.MohistForgeUtils;
import com.mohistmc.util.NumberUtils;
import com.mohistmc.util.i18n.Message;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;

public class DimensionManager {
    private static boolean hasInit = false;
    private static int lastUsedId = 0;
    private static final Int2ObjectMap<oo> worlds = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final Int2ObjectMap<Dimension> dimensions = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final IntSet keepLoaded = IntSets.synchronize((IntSet)new IntOpenHashSet());
    private static final IntSet unloadQueue = IntSets.synchronize((IntSet)new IntLinkedOpenHashSet());
    private static final IntSet usedIds = new IntOpenHashSet();
    private static final ConcurrentMap<amu, amu> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Multiset<Integer> leakedWorlds = HashMultiset.create();
    private static ArrayList<Integer> bukkitDims = new ArrayList();

    public static int[] getDimensions(ayn type) {
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Int2ObjectMap.Entry ent : dimensions.int2ObjectEntrySet()) {
            if (((Dimension)ent.getValue()).type != type) continue;
            ret[x++] = ent.getIntKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static Map<ayn, IntSortedSet> getRegisteredDimensions() {
        IdentityHashMap<ayn, IntSortedSet> map = new IdentityHashMap<ayn, IntSortedSet>();
        for (Int2ObjectMap.Entry entry : dimensions.int2ObjectEntrySet()) {
            map.computeIfAbsent(((Dimension)entry.getValue()).type, k -> new IntRBTreeSet()).add(entry.getIntKey());
        }
        return map;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, ayn.a);
        DimensionManager.registerDimension(-1, ayn.b);
        DimensionManager.registerDimension(1, ayn.c);
    }

    public static void registerDimension(int id, ayn type) {
        ayn.a((int)type.a());
        for (Integer dim : MohistConfig.instance.dimensionsNotLoaded) {
            if (id == 0 || dim != id) continue;
            return;
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, (Object)new Dimension(type));
        if (id >= 0) {
            usedIds.add(id);
        }
        if (id != -1 && id != 0 && id != 1) {
            DimensionManager.registerBukkitDimension(id, type.b());
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static ayn getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return ((Dimension)dimensions.get(dim)).type;
    }

    public static aym getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).s;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll((Collection<?>)worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                amu w = (amu)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (amu w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.log.debug("The world {} ({}) may have leaked: first encounter (5 occurrences).\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.V().j());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.log.debug("The world {} ({}) may have leaked: seen {} times.\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.V().j(), (Object)leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return (Integer[])worlds.keySet().toArray((Object[])new Integer[0]);
    }

    public static void setWorld(int id, @Nullable oo world, MinecraftServer server) {
        Object[] p2;
        if (world != null) {
            worlds.put(id, (Object)world);
            weakWorldMap.put((amu)world, (amu)world);
            if (!server.worldServerList.contains(world)) {
                server.worldServerList.add(world);
            }
            server.worldTickTimes.put(id, new long[100]);
            p2 = new Object[]{id, world.V().j()};
            FMLLog.log.info(Message.getFormatString("load.dimension", p2));
        } else {
            server.worldServerList.remove(DimensionManager.getWorld(id));
            worlds.remove(id);
            server.worldTickTimes.remove(id);
            p2 = new Object[]{id};
            FMLLog.log.info(Message.getFormatString("unload.dimension", p2));
        }
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Int2ObjectMap.Entry entry : worlds.int2ObjectEntrySet()) {
            int dim = entry.getIntKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        server.d = tmp.toArray(new oo[0]);
    }

    public static void initDimension(int dim) {
        if (dim == 0) {
            return;
        }
        ModCompatibleFixUtils.fixPortalEnter(dim);
        oo overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            if (MohistForgeUtils.craftWorldLoading) {
                return;
            }
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            FMLLog.log.error("Cannot Hotload Dim: {}", (Object)dim);
            return;
        }
        String name = "DIM" + dim;
        MinecraftServer mcServer = overworld.u();
        bey saveHandler = new bey(mcServer.server.getWorldContainer(), name, true, mcServer.getDataFixer());
        amx worldSettings = new amx(overworld.V());
        World.Environment env = World.Environment.getEnvironment(dim);
        if (dim >= -1 && dim <= 1) {
            if (dim == -1 && !mcServer.E() || dim == 1 && !mcServer.server.getAllowEnd()) {
                return;
            }
        } else if (World.Environment.getEnvironment(DimensionManager.getProviderType(dim).a()) == null) {
            env = DimensionManager.registerBukkitDimension(DimensionManager.getProviderType(dim).a(), DimensionManager.getProviderType(dim).b());
        }
        ChunkGenerator gen = mcServer.server.getGenerator(name);
        if (mcServer instanceof nz) {
            worldSettings.a(((nz)mcServer).a("generator-settings", ""));
        }
        bfd worldInfo = new bfd(worldSettings, name);
        oo world = dim == 0 ? overworld : (oo)new ok(mcServer, (bfe)saveHandler, dim, overworld, mcServer.c, worldInfo, env, gen).b();
        world.a(worldSettings);
        mcServer.am().a(mcServer.worldServerList.toArray(new oo[0]));
        world.a((amw)new op(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((amu)world));
        mcServer.server.getPluginManager().callEvent(new WorldLoadEvent(world.getWorld()));
        if (!mcServer.R()) {
            world.V().a(mcServer.n());
        }
        mcServer.a(mcServer.o());
    }

    public static oo getWorld(int id) {
        return DimensionManager.getWorld(id, false);
    }

    public static oo getWorld(int id, boolean resetUnloadDelay) {
        if (resetUnloadDelay && unloadQueue.contains(id)) {
            ((Dimension)dimensions.get(id)).ticksWaited = 0;
        }
        return (oo)worlds.get(id);
    }

    public static oo[] getWorlds() {
        return (oo[])worlds.values().toArray((Object[])new oo[0]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return (Integer[])dimensions.keySet().toArray((Object[])new Integer[0]);
    }

    public static aym createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                aym ret = DimensionManager.getProviderType(dim).d();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLLog.log.error("An error occurred trying to create an instance of WorldProvider {} ({})", (Object)dim, (Object)DimensionManager.getProviderType(dim), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean keepDimensionLoaded(int dim, boolean keep) {
        return keep ? keepLoaded.add(dim) : keepLoaded.remove(dim);
    }

    private static boolean canUnloadWorld(oo world) {
        return ForgeChunkManager.getPersistentChunksFor((amu)world).isEmpty() && world.i.isEmpty() && !world.s.q().shouldLoadSpawn() && !keepLoaded.contains(world.s.getDimension()) && world.getWorld().getKeepSpawnInMemory();
    }

    public static void unloadWorld(int id) {
        oo world = (oo)worlds.get(id);
        if (world == null || !DimensionManager.canUnloadWorld(world)) {
            return;
        }
        if (!MohistConfig.instance.autounloadworldenable.getValue().booleanValue()) {
            return;
        }
        for (String dim1 : MohistConfig.instance.autounloadworld_whitelist) {
            if (!dim1.equals("*") && (!NumberUtils.isInteger(dim1) || Integer.valueOf(dim1) != id)) continue;
            return;
        }
        if (unloadQueue.add(id)) {
            FMLLog.log.debug("Queueing dimension {} to unload", (Object)id);
        }
    }

    public static boolean isWorldQueuedToUnload(int id) {
        return unloadQueue.contains(id);
    }

    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        IntIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = queueIterator.nextInt();
            Dimension dimension = (Dimension)dimensions.get(id);
            if (dimension.ticksWaited < ForgeModContainer.dimensionUnloadQueueDelay) {
                dimension.ticksWaited++;
                continue;
            }
            oo w = (oo)worlds.get(id);
            queueIterator.remove();
            dimension.ticksWaited = 0;
            if (w == null || !DimensionManager.canUnloadWorld(w)) {
                FMLLog.log.debug("Aborting unload for dimension {} as status changed", (Object)id);
                continue;
            }
            MinecraftServer.getServerInst().server.unloadWorld(w.getWorld(), true);
        }
    }

    public static int getNextFreeDimId() {
        int next = lastUsedId;
        while (usedIds.contains(next) || !DimensionManager.checkAvailable(next)) {
            ++next;
        }
        lastUsedId = next;
        return lastUsedId;
    }

    private static boolean checkAvailable(int id) {
        if (dimensions.containsKey(id)) {
            usedIds.add(id);
            return false;
        }
        return true;
    }

    public static fy saveDimensionDataMap() {
        fy dimMap = new fy();
        dimMap.a("UsedIDs", usedIds.toIntArray());
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable fy compoundTag) {
        usedIds.clear();
        lastUsedId = 0;
        if (compoundTag == null) {
            IntIterator iterator = dimensions.keySet().iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextInt();
                if (id < 0) continue;
                usedIds.add(id);
            }
        } else {
            for (int id : compoundTag.n("UsedIDs")) {
                usedIds.add(id);
            }
            int[] intArray = compoundTag.n("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                int data = intArray[i2];
                if (data == 0) continue;
                for (int j = 0; j < 32; ++j) {
                    if ((data & 1 << j) == 0) continue;
                    usedIds.add(i2 * 32 + j);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).U().b();
        }
        return null;
    }

    public static oo initDimension(WorldCreator creator, amx worldSettings) {
        bfd worldinfo;
        int savedDim2;
        oo overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        MinecraftServer mcServer = overworld.u();
        ayn type = ayn.a;
        try {
            if (creator.environment() != null) {
                type = ayn.a((int)creator.environment().getId());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        World.Environment env = creator.environment();
        String name = creator.name();
        int dim = 0;
        bey saveHandler = new bey(mcServer.server.getWorldContainer(), name, true, mcServer.getDataFixer());
        if (saveHandler.d() != null && (savedDim2 = saveHandler.d().getDimension()) != 0 && savedDim2 != -1 && savedDim2 != 1) {
            dim = savedDim2;
        }
        if (dim == 0 || worlds.containsKey(dim)) {
            dim = DimensionManager.getNextFreeDimId();
        }
        if (!DimensionManager.isDimensionRegistered(dim)) {
            DimensionManager.registerDimension(dim, type);
            DimensionManager.addBukkitDimension(dim);
        }
        if (env == null) {
            try {
                env = World.Environment.getEnvironment(DimensionManager.createProviderFor(dim).getDimension());
            }
            catch (Exception savedDim2) {
                // empty catch block
            }
            if (env == null) {
                env = World.Environment.NORMAL;
            }
        }
        ChunkGenerator gen = creator.generator();
        if (mcServer instanceof nz) {
            worldSettings.a(((nz)mcServer).a("generator-settings", ""));
        }
        if ((worldinfo = saveHandler.d()) == null) {
            worldinfo = new bfd(worldSettings, name);
        }
        worldinfo.a(name);
        worldinfo.setDimension(dim);
        oo world = (oo)new oo(mcServer, (bfe)saveHandler, worldinfo, dim, mcServer.c, env, gen).b();
        world.a(worldSettings);
        world.s.setDimension(dim);
        mcServer.am().a(mcServer.worldServerList.toArray(new oo[0]));
        world.a((amw)new op(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((amu)world));
        if (!mcServer.R()) {
            world.V().a(mcServer.n());
        }
        return world;
    }

    public static World.Environment registerBukkitDimension(int dim, String providerName) {
        World.Environment env = World.Environment.getEnvironment(dim);
        if (env == null) {
            providerName = providerName.replace("WorldProvider", "");
            env = ForgeInjectBukkit.addEnumEnvironment(dim, providerName.toUpperCase());
            World.Environment.registerEnvironment(env);
        }
        return env;
    }

    public static void addBukkitDimension(int dim) {
        if (!bukkitDims.contains(dim)) {
            bukkitDims.add(dim);
        }
    }

    public static void removeBukkitDimension(int dim) {
        if (bukkitDims.contains(dim)) {
            bukkitDims.remove(bukkitDims.indexOf(dim));
        }
    }

    public static ArrayList<Integer> getBukkitDimensionIDs() {
        return bukkitDims;
    }

    public static boolean isBukkitDimension(int dim) {
        return bukkitDims.contains(dim);
    }

    static {
        DimensionManager.init();
    }

    private static class Dimension {
        private final ayn type;
        private int ticksWaited;

        private Dimension(ayn type) {
            this.type = type;
            this.ticksWaited = 0;
        }
    }
}

