/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.mohistmc.api.ServerAPI;
import com.mohistmc.forge.ForgeInjectBukkit;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;

public class BukkitPermissionsHandler
implements IPermissionHandler {
    @Override
    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        ForgeInjectBukkit.registerDefaultPermission(node, level, desc);
    }

    @Override
    public Collection<String> getRegisteredNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Permission permission : Bukkit.getPluginManager().getPermissions()) {
            String name = permission.getName();
            list.add(name);
        }
        return list;
    }

    @Override
    public boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        Object player;
        if (context != null && (player = context.getPlayer()) != null) {
            return player.getBukkitEntity().hasPermission(node);
        }
        player = Bukkit.getServer().getPlayer(profile.getId());
        if (player != null) {
            return player.hasPermission(node);
        }
        Permission perm = Bukkit.getServer().getPluginManager().getPermission(node);
        boolean isOp = ServerAPI.getNMSServer().am().h(profile);
        if (perm != null) {
            return perm.getDefault().getValue(isOp);
        }
        return Permission.DEFAULT_PERMISSION.getValue(isOp);
    }

    @Override
    public String getNodeDescription(String node) {
        Permission permission = Bukkit.getPluginManager().getPermission(node);
        return permission == null ? "" : permission.getDescription();
    }
}

