/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.util.Bounds;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUpgradedGate
extends BlockFurniture {
    public static final PropertyEnum<BlockDoor.EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", BlockDoor.EnumHingePosition.class);
    public static final PropertyBool OPENED = PropertyBool.func_177716_a((String)"opened");
    public static final PropertyBool POLE = PropertyBool.func_177716_a((String)"pole");
    private static final AxisAlignedBB[] BOUNDING_BOXES = new Bounds(6, 0, -1, 10, 16, 17).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_BOXES = new Bounds(6, 0, -1, 10, 24, 17).getRotatedBounds();

    public BlockUpgradedGate(String id) {
        super(Material.field_151575_d);
        this.func_149663_c(id);
        this.setRegistryName(id);
        this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HINGE, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf(false));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)OPENED)).booleanValue()) {
            return field_185506_k;
        }
        return COLLISION_BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()];
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean open = (Boolean)state.func_177229_b((IProperty)OPENED) == false;
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf(open)));
        EnumFacing rot = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing offset = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.LEFT ? rot.func_176746_e() : rot.func_176735_f();
        IBlockState adjacentBlock = worldIn.func_180495_p(pos.func_177972_a(offset));
        if (adjacentBlock.func_177230_c() instanceof BlockUpgradedGate && adjacentBlock.func_177229_b((IProperty)FACING) == rot && adjacentBlock.func_177229_b(HINGE) != state.func_177229_b(HINGE)) {
            worldIn.func_175656_a(pos.func_177972_a(offset), adjacentBlock.func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf(open)));
        }
        this.openGate(worldIn, pos, EnumFacing.UP, rot, (BlockDoor.EnumHingePosition)state.func_177229_b(HINGE), open, 4);
        this.openGate(worldIn, pos, EnumFacing.DOWN, rot, (BlockDoor.EnumHingePosition)state.func_177229_b(HINGE), open, 4);
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)OPENED) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    private void openGate(World world, BlockPos pos, EnumFacing direction, EnumFacing facing, BlockDoor.EnumHingePosition hingePosition, boolean open, int limit) {
        if (limit <= 0) {
            return;
        }
        BlockPos offsetPos = pos.func_177972_a(direction);
        IBlockState state = world.func_180495_p(offsetPos);
        if (state.func_177230_c() == this && state.func_177229_b((IProperty)FACING) == facing && state.func_177229_b(HINGE) == hingePosition) {
            world.func_175656_a(offsetPos, state.func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf(open)));
            EnumFacing offset = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.LEFT ? facing.func_176746_e() : facing.func_176735_f();
            BlockPos adjacentPos = offsetPos.func_177972_a(offset);
            IBlockState adjacentBlock = world.func_180495_p(adjacentPos);
            if (adjacentBlock.func_177230_c() instanceof BlockUpgradedGate && adjacentBlock.func_177229_b((IProperty)FACING) == facing && adjacentBlock.func_177229_b(HINGE) != state.func_177229_b(HINGE)) {
                world.func_175656_a(adjacentPos, adjacentBlock.func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf(open)));
            }
            this.openGate(world, offsetPos, direction, facing, hingePosition, open, limit - 1);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing offset = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.LEFT ? facing.func_176746_e() : facing.func_176735_f();
        IBlockState adjacentBlock = worldIn.func_180495_p(pos.func_177972_a(offset));
        return state.func_177226_a((IProperty)POLE, (Comparable)Boolean.valueOf(!(adjacentBlock.func_177230_c() instanceof BlockUpgradedGate)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)OPENED, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a(HINGE, (Comparable)((meta & 8) == 0 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT) {
            i |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)OPENED)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HINGE, OPENED, POLE});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockFence || connector instanceof BlockWall;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)OPENED) == false ? PathNodeType.FENCE : PathNodeType.OPEN;
    }
}

